/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.throttling;

import com.adobe.acs.commons.throttling.LoadEstimator;
import com.adobe.acs.commons.throttling.ThrottlingDecision;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingState {
    private static final Logger LOG = LoggerFactory.getLogger(ThrottlingState.class);
    protected Instant[] timestamps;
    private Clock clock;
    protected LoadEstimator loadEstimator;
    private static final long ONE_MINUTE = 60000L;
    protected AtomicInteger currentIndex = new AtomicInteger();

    protected ThrottlingState(Clock clock, LoadEstimator le) {
        int queueLen = le.getMaxRequestPerMinute();
        this.clock = clock;
        this.loadEstimator = le;
        this.timestamps = new Instant[queueLen];
        for (int i = 0; i < queueLen; ++i) {
            this.timestamps[i] = Instant.EPOCH;
        }
        this.currentIndex.set(0);
    }

    protected synchronized ThrottlingDecision evaluateThrottling() {
        ThrottlingDecision result = null;
        this.purgeExpiredEntries();
        this.resize(this.loadEstimator.getMaxRequestPerMinute());
        int idx = this.currentIndex.get();
        if (this.isSlotEmpty(idx)) {
            this.timestamps[idx] = this.clock.instant();
            this.currentIndex.updateAndGet(index -> index == this.timestamps.length - 1 ? 0 : index + 1);
            result = new ThrottlingDecision(ThrottlingDecision.State.NOTHROTTLE);
        } else {
            long diff = this.timestamps[idx].toEpochMilli() + 60000L - this.clock.instant().toEpochMilli();
            result = new ThrottlingDecision(ThrottlingDecision.State.THROTTLE).withDelay(diff).withMessage("throttling required (at least " + diff + " ms)");
        }
        return result;
    }

    private int purgeExpiredEntries() {
        int result = 0;
        for (int i = 0; i < this.timestamps.length; ++i) {
            long now = this.clock.instant().toEpochMilli();
            if (now - this.timestamps[i].toEpochMilli() <= 60000L) continue;
            this.timestamps[i] = Instant.EPOCH;
            ++result;
        }
        return result;
    }

    protected int resize(int newSize) {
        if (newSize != this.timestamps.length) {
            LOG.debug("Resizing throttling queue from {} to {}", (Object)this.timestamps.length, (Object)newSize);
            Instant[] newQueue = new Instant[newSize];
            int result = 0;
            result = this.timestamps.length - newSize > 0 ? this.reduceSize(newQueue) : this.increaseSize(newQueue);
            this.timestamps = newQueue;
            return result;
        }
        LOG.debug("No resizing required");
        return 0;
    }

    private int increaseSize(Instant[] newQueue) {
        int i;
        for (i = 0; i < this.timestamps.length; ++i) {
            newQueue[i] = this.timestamps[i];
        }
        for (i = this.timestamps.length; i < newQueue.length; ++i) {
            newQueue[i] = Instant.EPOCH;
        }
        this.currentIndex.set(this.timestamps.length);
        return newQueue.length - this.timestamps.length;
    }

    private int reduceSize(Instant[] newQueue) {
        int i;
        int newIndex = 0;
        for (i = this.currentIndex.get() - 1; i >= 0 && newIndex < newQueue.length; --i, ++newIndex) {
            newQueue[newIndex] = this.timestamps[i];
        }
        for (i = this.timestamps.length - 1; i > this.currentIndex.get() && newIndex < newQueue.length; --i, ++newIndex) {
            newQueue[newIndex] = this.timestamps[i];
        }
        this.currentIndex.set(0);
        return 0;
    }

    private boolean isSlotEmpty(int index) {
        return this.timestamps[index] == Instant.EPOCH;
    }
}

