/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.throttling;

import com.adobe.acs.commons.throttling.LoadEstimator;
import com.adobe.acs.commons.throttling.ThrottlingConfiguration;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuLoadEstimator
implements LoadEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(CpuLoadEstimator.class);
    private static final String OPERATING_SYSTEM_MBEAN = "java.lang:type=OperatingSystem";
    private static final String CPU_LOAD = "SystemCpuLoad";
    MBeanServer mbs;
    ObjectName name;
    ThrottlingConfiguration tc;

    public CpuLoadEstimator(ThrottlingConfiguration tc) {
        this.tc = tc;
        this.preseed();
    }

    protected void preseed() {
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.name = new ObjectName(OPERATING_SYSTEM_MBEAN);
        }
        catch (MalformedObjectNameException e) {
            String message = String.format("invalid mbean name %s", OPERATING_SYSTEM_MBEAN);
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (!this.mbs.isRegistered(this.name)) {
            String message = String.format("Cannot determine CPU load via MBean %s, aborting (is it supported on your platform?)", this.name.toString());
            LOG.error(message);
            throw new IllegalStateException(message);
        }
    }

    @Override
    public int getMaxRequestPerMinute() {
        try {
            int cpuLoad = this.getCpuLoad();
            return CpuLoadEstimator.calculateRequests(cpuLoad, this.tc.startThrottlingPercentage, this.tc.maxRequests);
        }
        catch (JMException e) {
            LOG.warn("Cannot query mbean %s, do not throttle at all!", (Object)this.name.toString(), (Object)e);
            return this.tc.maxRequests;
        }
    }

    static int calculateRequests(int cpuLoad, int limit, int maxRequests) {
        if (cpuLoad < limit) {
            return maxRequests;
        }
        if (limit == 100) {
            return maxRequests;
        }
        double fillLevel = (100.0 - (double)cpuLoad) / (100.0 - (double)limit);
        return (int)Math.round(fillLevel * (double)maxRequests);
    }

    private int getCpuLoad() throws JMException {
        Object v = this.mbs.getAttribute(this.name, CPU_LOAD);
        Double d = Double.parseDouble(v.toString());
        return (int)Math.round(d);
    }
}

