/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.remoteassets.impl;

import com.adobe.acs.commons.remoteassets.RemoteAssetsNodeSync;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={Runnable.class}, property={"scheduler.concurrent:Boolean=false"})
@Designate(ocd=Config.class)
public class RemoteAssetsNodeSyncScheduler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAssetsNodeSyncScheduler.class);
    @Reference
    private RemoteAssetsNodeSync remoteAssetsNodeSync;

    @Override
    public final void run() {
        LOG.info("Remote assets node sync job started.");
        this.remoteAssetsNodeSync.syncAssetNodes();
        LOG.info("Remote assets node sync job finished.");
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Remote Assets Sync Scheduler", description="Scheduled Service that runs the Remote Assets node sync.")
    public static @interface Config {
        public static final String DEFAULT_SCHEDULER_EXPRESSION = "0 0 0,4,8,12,16,20 ? * *";

        @AttributeDefinition(name="Cron expression defining when this Scheduled Service will run", description="Default value ('0 0 0,4,8,12,16,20 ? * *') will run this job every 4 hours starting at 00:00.", defaultValue={"0 0 0,4,8,12,16,20 ? * *"})
        public String scheduler_expression() default "0 0 0,4,8,12,16,20 ? * *";
    }
}

