/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.oak.EnsureOakIndexManager;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"felix.webconsole.title=Ensure Oak Index (ACS AEM Commons)", "felix.webconsole.label=ensure-oak-index", "felix.webconsole.category=Sling"})
public class EnsureOakIndexServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(EnsureOakIndexServlet.class);
    private static final String PARAM_FORCE = "force";
    private static final String PARAM_PATH = "path";
    @Reference
    private transient EnsureOakIndexManager ensureOakIndexManager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setStatus(405);
            response.getWriter().println(IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("EnsureOakIndexServlet_doGet.html"), (String)"UTF-8"));
        }
        catch (IOException e) {
            log.warn("Caught IOException while handling doGet() in the Ensure Oak Index Servlet.", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String forceParam = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(PARAM_FORCE), (CharSequence)"false");
        boolean force = Boolean.parseBoolean(forceParam);
        String path = StringUtils.stripToNull((String)request.getParameter(PARAM_PATH));
        try {
            String message;
            if (StringUtils.isBlank((CharSequence)path)) {
                int count = this.ensureOakIndexManager.ensureAll(force);
                message = String.format("Initiated the FORCE ensuring of [ %d ] all oak index ensure definitions", count);
            } else {
                int count = this.ensureOakIndexManager.ensure(force, path);
                message = String.format("Initiated the [ %s ] ensuring of [ %d ] oak index ensure definitions at path [ %s ]", force ? "FORCE" : "UN-FORCED", count, path);
            }
            response.setContentType("text/plain; charset=utf-8");
            response.getWriter().println(message);
            response.setStatus(200);
        }
        catch (IOException e) {
            log.warn("Caught IOException while handling doPost() in the Ensure Oak Index Servlet", (Throwable)e);
            response.setStatus(500);
        }
    }
}

