/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="type", value={"scale"})})
@Service
public class ScaleImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(ScaleImageTransformerImpl.class);
    static final String TYPE = "scale";
    private static final String KEY_SCALE = "scale";
    private static final String KEY_ROUND = "round";
    private static final String ROUND_UP = "up";
    private static final String ROUND_DOWN = "down";
    @Reference(target="(type=resize)")
    ImageTransformer resizeImageTransformer;

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)"scale");
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)"scale");
        Double scale = (Double)properties.get("scale", (Object)1.0);
        String round = StringUtils.trim((String)((String)properties.get(KEY_ROUND, String.class)));
        if (scale == null) {
            log.warn("Could not derive a Double value for key [ {} ] from value [ {} ]", (Object)"scale", properties.get("scale", String.class));
            scale = 1.0;
        }
        if (scale != 1.0) {
            int currentWidth = layer.getWidth();
            int currentHeight = layer.getHeight();
            double newWidth = scale * (double)currentWidth;
            double newHeight = scale * (double)currentHeight;
            if (StringUtils.equals((CharSequence)ROUND_UP, (CharSequence)round)) {
                newWidth = (int)Math.ceil(newWidth);
                newHeight = (int)Math.ceil(newHeight);
            } else if (StringUtils.equals((CharSequence)ROUND_DOWN, (CharSequence)round)) {
                newWidth = (int)Math.floor(newWidth);
                newHeight = (int)Math.floor(newHeight);
            } else {
                newWidth = (int)Math.round(newWidth);
                newHeight = (int)Math.round(newHeight);
            }
            ValueMapDecorator params = new ValueMapDecorator(new HashMap());
            params.put((Object)"width", (Object)((int)newWidth));
            params.put((Object)"height", (Object)((int)newHeight));
            layer = this.resizeImageTransformer.transform(layer, (ValueMap)params);
        }
        return layer;
    }

    protected void bindResizeImageTransformer(ImageTransformer imageTransformer) {
        this.resizeImageTransformer = imageTransformer;
    }

    protected void unbindResizeImageTransformer(ImageTransformer imageTransformer) {
        if (this.resizeImageTransformer == imageTransformer) {
            this.resizeImageTransformer = null;
        }
    }
}

