/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine.impl;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.commons.io.output.TeeOutputStream;

public class TeeServletOutputStream
extends ServletOutputStream {
    private final TeeOutputStream teeOutputStream;
    private WriteListener listener = new WriteListener(){

        public void onWritePossible() throws IOException {
        }

        public void onError(Throwable throwable) {
        }
    };

    public TeeServletOutputStream(OutputStream one, OutputStream two) {
        this.teeOutputStream = new TeeOutputStream(one, two);
    }

    public void write(int character) throws IOException {
        try {
            this.teeOutputStream.write(character);
        }
        catch (IOException ex) {
            this.listener.onError((Throwable)ex);
            throw ex;
        }
    }

    public void write(byte[] oneByte, int off, int len) throws IOException {
        try {
            this.teeOutputStream.write(oneByte, off, len);
        }
        catch (IOException ex) {
            this.listener.onError((Throwable)ex);
            throw ex;
        }
    }

    public void write(byte[] oneByte) throws IOException {
        try {
            this.teeOutputStream.write(oneByte);
        }
        catch (IOException ex) {
            this.listener.onError((Throwable)ex);
            throw ex;
        }
    }

    public void flush() throws IOException {
        try {
            this.teeOutputStream.flush();
        }
        catch (IOException ex) {
            this.listener.onError((Throwable)ex);
            throw ex;
        }
    }

    public void close() throws IOException {
        this.teeOutputStream.close();
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
        this.listener = writeListener;
        try {
            writeListener.onWritePossible();
        }
        catch (IOException e) {
            this.listener.onError((Throwable)e);
        }
    }
}

