/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelHandler
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CancelHandler.class);
    private static final long serialVersionUID = 7526472295622776147L;
    private final transient Set<Thread> activeWork = ConcurrentHashMap.newKeySet();
    private boolean cancelled = false;
    private boolean force = false;

    public void cancel(boolean useForce) {
        this.cancelled = true;
        this.force = useForce;
        if (useForce) {
            this.activeWork.forEach(Thread::interrupt);
        }
        this.activeWork.clear();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isForcefullyCancelled() {
        return this.force;
    }

    public void trackActiveWork(Thread t) {
        if (this.cancelled) {
            log.warn("Thread interruption is no longer supported as it can result in repository corruption.");
        } else {
            this.activeWork.add(t);
        }
    }

    public void untrackActiveWork(Thread t) {
        this.activeWork.remove(t);
    }
}

