/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.audio.impl;

import com.adobe.acs.commons.dam.audio.impl.AudioException;
import com.adobe.acs.commons.dam.audio.impl.AudioHelper;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.FFMpegTranscodeProcess;
import com.day.cq.dam.video.VideoProfile;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={WorkflowProcess.class})
@Properties(value={@Property(name="process.label", value={"Encode Audio"})})
public final class FFMpegAudioEncodeProcess
implements WorkflowProcess,
AudioHelper.AudioProcessor<MetaDataMap, Void> {
    @Reference
    private AudioHelper helper;
    @Reference
    private WorkflowHelper workflowHelper;
    private static final Logger log = LoggerFactory.getLogger(FFMpegAudioEncodeProcess.class);

    public final void execute(WorkItem workItem, WorkflowSession wfSession, MetaDataMap metaData) throws WorkflowException {
        WorkflowHelper.AssetResourceResolverPair pair = this.workflowHelper.getAssetFromPayload(workItem, wfSession);
        if (pair == null) {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot process audio, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
        String assetMimeType = pair.asset.getMimeType();
        if (!(assetMimeType != null && assetMimeType.startsWith("audio/") || pair.asset.getName().endsWith(".wav") && pair.asset.getName().endsWith(".mp3") && pair.asset.getName().endsWith(".ogg"))) {
            log.info("execute: asset [{}] is not of a audio mime type, asset ignored.", (Object)pair.asset.getPath());
            return;
        }
        try {
            this.helper.process(pair.asset, pair.resourceResolver, metaData, this);
        }
        catch (AudioException e) {
            throw new WorkflowException("Unable to transcode audio", (Throwable)e);
        }
        finally {
            pair.resourceResolver.close();
        }
    }

    @Override
    public Void processAudio(Asset asset, ResourceResolver resourceResolver, File tempFile, ExecutableLocator locator, File workingDir, MetaDataMap metaData) throws AudioException {
        String[] videoProfiles;
        long start = System.currentTimeMillis();
        log.info("processing asset [{}]...", (Object)asset.getPath());
        for (String videoProfile : videoProfiles = this.getVideoProfiles(metaData)) {
            VideoProfile profile = VideoProfile.get((ResourceResolver)resourceResolver, (String)videoProfile);
            if (profile == null) continue;
            log.info("processAudio: creating audio using profile [{}]", (Object)videoProfile);
            FFMpegWrapper ffmpegWrapper = FFMpegWrapper.fromProfile((File)tempFile, (VideoProfile)profile, (File)workingDir);
            ffmpegWrapper.setExecutableLocator(locator);
            FileInputStream fis = null;
            try {
                String renditionName = this.getRenditionName(ffmpegWrapper);
                File transcodedAudio = ffmpegWrapper.transcode();
                fis = new FileInputStream(transcodedAudio);
                asset.addRendition(renditionName, (InputStream)fis, ffmpegWrapper.getOutputMimetype());
                try {
                    Files.delete(transcodedAudio.toPath());
                }
                catch (Exception e) {
                    log.error("Transcoded audio file @ " + transcodedAudio.getAbsolutePath() + " coud not be deleted", (Throwable)e);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("processAudio: failed creating audio from profile [{}]: {}", (Object)videoProfile, (Object)e.getMessage());
            }
        }
        if (log.isInfoEnabled()) {
            long time = System.currentTimeMillis() - start;
            log.info("finished processing asset [{}] in [{}ms].", (Object)asset.getPath(), (Object)time);
        }
        FFMpegWrapper wrapper = new FFMpegWrapper(tempFile, workingDir);
        wrapper.setExecutableLocator(locator);
        Resource assetResource = (Resource)asset.adaptTo(Resource.class);
        Resource metadata = resourceResolver.getResource(assetResource, "jcr:content/metadata");
        if (null != metadata) {
            try {
                Node metadataNode = (Node)metadata.adaptTo(Node.class);
                if (metadataNode != null) {
                    metadataNode.setProperty("dc:extent", wrapper.getInputDuration());
                }
            }
            catch (RepositoryException e) {
                log.warn("Unable to set metadata for asset [" + asset.getPath() + "]", (Throwable)e);
            }
        } else {
            log.warn("execute: failed setting metdata for asset [{}], no metdata node found.", (Object)asset.getPath());
        }
        return null;
    }

    private String[] getVideoProfiles(MetaDataMap metaData) {
        List<String> profiles = this.workflowHelper.getValuesFromArgs(FFMpegTranscodeProcess.Arguments.VIDEO_PROFILES.getArgumentName(), this.workflowHelper.buildArguments(metaData));
        return profiles.toArray(new String[profiles.size()]);
    }

    private String getRenditionName(FFMpegWrapper ffmpegWrapper) {
        String outputFormat = ffmpegWrapper.getOutputExtension();
        String profileName = ffmpegWrapper.getProfileName();
        StringBuilder builder = new StringBuilder();
        builder.append("cq5dam.audio.").append(profileName);
        builder.append(".").append(outputFormat);
        return builder.toString();
    }

    protected void bindHelper(AudioHelper audioHelper) {
        this.helper = audioHelper;
    }

    protected void unbindHelper(AudioHelper audioHelper) {
        if (this.helper == audioHelper) {
            this.helper = null;
        }
    }

    protected void bindWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    protected void unbindWorkflowHelper(WorkflowHelper workflowHelper) {
        if (this.workflowHelper == workflowHelper) {
            this.workflowHelper = null;
        }
    }
}

