/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync.impl;

import com.adobe.granite.crypto.CryptoSupport;
import java.util.List;
import javax.jcr.Property;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class EncryptPasswordPostProcessor
implements SlingPostProcessor {
    static final String PASSWORD_PROPERTY = "password";
    @Reference
    private CryptoSupport crypto;

    public void process(SlingHttpServletRequest slingRequest, List<Modification> changes) throws Exception {
        Session session = (Session)slingRequest.getResourceResolver().adaptTo(Session.class);
        block3: for (Modification mod : changes) {
            String path = mod.getSource();
            if (!path.startsWith("/var/acs-commons/contentsync/hosts")) continue;
            switch (mod.getType()) {
                case MODIFY: 
                case CREATE: {
                    if (!path.endsWith("/password") || !session.propertyExists(path)) break;
                    Property property = session.getProperty(path);
                    String password = property.getString();
                    if (this.crypto.isProtected(password)) continue block3;
                    String encrypted = this.crypto.protect(password);
                    property.setValue(encrypted);
                    break;
                }
            }
        }
    }
}

