/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.ccvar.filter;

import com.adobe.acs.commons.ccvar.PropertyAggregatorService;
import com.adobe.acs.commons.ccvar.PropertyConfigService;
import com.adobe.acs.commons.ccvar.filter.CapturingResponseWrapper;
import com.adobe.acs.commons.ccvar.util.ContentVariableReplacementUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"service.ranking:Integer=-2147483648", "sling.filter.scope=REQUEST", "sling.filter.pattern=/content/.*"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class ContentVariableJsonFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ContentVariableJsonFilter.class);
    @Reference
    private PropertyAggregatorService propertyAggregatorService;
    @Reference
    private PropertyConfigService propertyConfigService;
    private List<Pattern> includePatterns;
    private List<Pattern> excludePatterns;
    private boolean allInvalidIncludes;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        SlingHttpServletRequest slingHttpServletRequest = (SlingHttpServletRequest)servletRequest;
        RequestPathInfo currentPathInfo = slingHttpServletRequest.getRequestPathInfo();
        if (StringUtils.equals((CharSequence)currentPathInfo.getExtension(), (CharSequence)"json") && this.shouldProcess(slingHttpServletRequest.getPathInfo())) {
            String currentResponse;
            CapturingResponseWrapper capturingResponseWrapper = new CapturingResponseWrapper((HttpServletResponse)((SlingHttpServletResponse)servletResponse));
            filterChain.doFilter(servletRequest, (ServletResponse)capturingResponseWrapper);
            String toReturn = currentResponse = capturingResponseWrapper.getCaptureAsString();
            try {
                Map<String, Object> contentVariableReplacements = this.propertyAggregatorService.getProperties(slingHttpServletRequest);
                if (contentVariableReplacements.size() <= 0) return;
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode currentTree = objectMapper.readTree(currentResponse);
                this.replaceInElements(currentTree, contentVariableReplacements);
                toReturn = currentTree.toString();
                return;
            }
            catch (Exception e) {
                LOG.error("Exception during JSON property replacement", (Throwable)e);
                return;
            }
            finally {
                servletResponse.getWriter().write(toReturn);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean shouldProcess(String urlPath) {
        if (this.allInvalidIncludes) {
            LOG.debug("Include patterns are empty due to invalid regex patterns, not processing any requests");
            return false;
        }
        if (this.includePatterns.isEmpty() && this.excludePatterns.isEmpty()) {
            LOG.debug("Include and Exclude patterns are empty, processing all requests");
            return true;
        }
        boolean shouldProcess = false;
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(urlPath).matches()) continue;
            LOG.debug("URL path {} matches INCLUDE pattern {}", (Object)urlPath, (Object)pattern.toString());
            shouldProcess = true;
            break;
        }
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(urlPath).matches()) continue;
            LOG.debug("URL path {} matches EXCLUDE pattern {}", (Object)urlPath, (Object)pattern.toString());
            shouldProcess = false;
            break;
        }
        LOG.debug("URL path {} is processed: {}", (Object)urlPath, (Object)shouldProcess);
        return shouldProcess;
    }

    private void replaceInElements(JsonNode node, Map<String, Object> contentVariableReplacements) {
        if (node.isArray()) {
            this.replaceInArray(node, contentVariableReplacements);
        } else if (node.isObject()) {
            this.replaceInObject(node, contentVariableReplacements);
        }
    }

    private void replaceInArray(JsonNode node, Map<String, Object> contentVariableReplacements) {
        block4: {
            block3: {
                if (node.get(0) == null || !node.get(0).isTextual()) break block3;
                LinkedList<String> updated = new LinkedList<String>();
                for (JsonNode arrayItem : node) {
                    String current = arrayItem.asText();
                    updated.add(this.replaceInString(current, contentVariableReplacements));
                }
                ((ArrayNode)node).removeAll();
                for (int i = 0; i < updated.size(); ++i) {
                    ((ArrayNode)node).insert(i, (String)updated.get(i));
                }
                break block4;
            }
            if (node.get(0) == null || !node.get(0).isContainerNode()) break block4;
            for (JsonNode arrayItem : node) {
                this.replaceInElements(arrayItem, contentVariableReplacements);
            }
        }
    }

    private void replaceInObject(JsonNode node, Map<String, Object> contentVariableReplacements) {
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String replaced;
            String current;
            String name = (String)fieldNames.next();
            JsonNode nodeValue = node.get(name);
            if (nodeValue.isContainerNode()) {
                this.replaceInElements(nodeValue, contentVariableReplacements);
                continue;
            }
            if (!nodeValue.isTextual() || StringUtils.equals((CharSequence)(current = nodeValue.asText()), (CharSequence)(replaced = this.replaceInString(current, contentVariableReplacements)))) continue;
            ((ObjectNode)node).put(name, replaced);
        }
    }

    private String replaceInString(String input, Map<String, Object> contentVariableReplacements) {
        List<String> keys = ContentVariableReplacementUtil.getKeys(input);
        for (String key : keys) {
            if (!ContentVariableReplacementUtil.hasKey(contentVariableReplacements, key)) continue;
            String replaceValue = (String)ContentVariableReplacementUtil.getValue(contentVariableReplacements, key);
            input = ContentVariableReplacementUtil.doReplacement(input, key, replaceValue, this.propertyConfigService.getAction(key));
        }
        return input;
    }

    public void destroy() {
    }

    @Activate
    protected void activate(Config config) {
        this.includePatterns = new ArrayList<Pattern>();
        this.excludePatterns = new ArrayList<Pattern>();
        boolean invalidInclude = false;
        for (String item : config.includes()) {
            if (!StringUtils.isNotBlank((CharSequence)item)) continue;
            try {
                this.includePatterns.add(Pattern.compile(item));
            }
            catch (PatternSyntaxException e) {
                invalidInclude = true;
                LOG.error("Error adding includePattern. Invalid syntax in {}", (Object)item);
            }
        }
        for (String item : config.excludes()) {
            if (!StringUtils.isNotBlank((CharSequence)item)) continue;
            try {
                this.excludePatterns.add(Pattern.compile(item));
            }
            catch (PatternSyntaxException e) {
                LOG.error("Error adding excludePattern. Invalid syntax in {}", (Object)item);
            }
        }
        if (invalidInclude && this.includePatterns.size() == 0) {
            this.allInvalidIncludes = true;
        }
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Contextual Content Variable JSON Filter Configuration", description="JSON Rewriting Filter for supporting Content Variable Property replacement in JSON responses. This filter only applies to /content/* and *.json requests. Additional filtering options are available below.")
    static @interface Config {
        @AttributeDefinition(name="Include Patterns", description="Regex patterns to for URL paths to INCLUDE in the JSON rewriting.")
        public String[] includes() default {".*\\.model\\..*"};

        @AttributeDefinition(name="Exclude Patterns", description="Regex patterns to for URL paths to EXCLUDE in the JSON rewriting. Exclusions hold priority over inclusions.")
        public String[] excludes();
    }
}

