/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl.servlets;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGenerator;
import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGeneratorOptions;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.ChecksumGeneratorOptionsFactory;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.RequestChecksumGeneratorOptions;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.servlets.BaseChecksumServlet;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="sling.servlet.paths", value={"/bin/acs-commons/jcr-compare.hashes.txt"}), @Property(name="sling.auth.requirements", value={"-/bin/acs-commons/jcr-compare.hashes.txt"})})
@Service
public class ChecksumGeneratorServlet
extends BaseChecksumServlet {
    public static final Logger log = LoggerFactory.getLogger(ChecksumGeneratorServlet.class);
    @Reference
    private transient ChecksumGenerator checksumGenerator;
    public static final String SERVLET_PATH = "/bin/acs-commons/jcr-compare.hashes.txt";

    public final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        try {
            this.handleCORS(request, response);
            this.handleRequest(request, response);
        }
        catch (IOException | RepositoryException e) {
            throw new ServletException(e);
        }
    }

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        try {
            this.handleCORS(request, response);
            this.handleRequest(request, response);
        }
        catch (IOException | RepositoryException e) {
            throw new ServletException(e);
        }
    }

    private void handleRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, RepositoryException {
        Set<String> paths;
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        String optionsName = request.getParameter("optionsName");
        ChecksumGeneratorOptions options = ChecksumGeneratorOptionsFactory.getOptions(request, optionsName);
        if (log.isDebugEnabled()) {
            log.debug(options.toString());
        }
        if (CollectionUtils.isEmpty(paths = RequestChecksumGeneratorOptions.getPaths(request))) {
            response.setStatus(400);
            response.getWriter().print("ERROR: At least one path must be specified");
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        for (String path : paths) {
            log.debug("Generating checksum for path [ {} ]", (Object)path);
            Map<String, String> checksums = this.checksumGenerator.generateChecksums(session, path, options);
            log.debug("Collected [ {} ] checksum entries under [ {} ]", (Object)checksums.size(), (Object)path);
            for (Map.Entry<String, String> entry : checksums.entrySet()) {
                log.trace("Checksum [ {} ~> {} ]", (Object)entry.getKey(), (Object)entry.getValue());
                response.getWriter().println(entry.getKey() + "\t" + entry.getValue());
            }
        }
    }

    protected void bindChecksumGenerator(ChecksumGenerator checksumGenerator) {
        this.checksumGenerator = checksumGenerator;
    }

    protected void unbindChecksumGenerator(ChecksumGenerator checksumGenerator) {
        if (this.checksumGenerator == checksumGenerator) {
            this.checksumGenerator = null;
        }
    }
}

