/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.impl.crypto;

import acscommons.io.jsonwebtoken.SignatureAlgorithm;
import acscommons.io.jsonwebtoken.impl.crypto.EllipticCurveProvider;
import acscommons.io.jsonwebtoken.impl.crypto.SignatureValidator;
import acscommons.io.jsonwebtoken.lang.Assert;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public class EllipticCurveSignatureValidator
extends EllipticCurveProvider
implements SignatureValidator {
    private static final String EC_PUBLIC_KEY_REQD_MSG = "Elliptic Curve signature validation requires an ECPublicKey instance.";
    private static final String DER_ENCODING_SYS_PROPERTY_NAME = "acscommons.io.jsonwebtoken.impl.crypto.EllipticCurveSignatureValidator.derEncodingSupported";

    public EllipticCurveSignatureValidator(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        Assert.isTrue(key instanceof ECPublicKey, EC_PUBLIC_KEY_REQD_MSG);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(byte[] data, byte[] concatSignature) {
        Signature sig = this.createSignatureInstance();
        PublicKey publicKey = (PublicKey)this.key;
        try {
            byte[] derSignature;
            int requiredConcatByteLength = EllipticCurveSignatureValidator.getSignatureByteArrayLength(this.alg);
            if (requiredConcatByteLength != concatSignature.length) {
                if (concatSignature[0] == 48 && "true".equalsIgnoreCase(System.getProperty(DER_ENCODING_SYS_PROPERTY_NAME))) {
                    derSignature = concatSignature;
                    return this.doVerify(sig, publicKey, data, derSignature);
                }
                String msg = "Provided signature is " + EllipticCurveSignatureValidator.byteSizeString(concatSignature.length) + " but " + this.alg.name() + " signatures must be exactly " + EllipticCurveSignatureValidator.byteSizeString(requiredConcatByteLength) + " per " + "[RFC 7518, Section 3.4 (validation)](https://datatracker.ietf.org/doc/html/rfc7518#section-3.4).";
                throw new acscommons.io.jsonwebtoken.security.SignatureException(msg);
            }
            ECKey ecKey = (ECKey)((Object)publicKey);
            BigInteger order = ecKey.getParams().getOrder();
            BigInteger r = new BigInteger(1, Arrays.copyOfRange(concatSignature, 0, this.fieldByteLength));
            BigInteger s = new BigInteger(1, Arrays.copyOfRange(concatSignature, this.fieldByteLength, concatSignature.length));
            if (r.signum() < 1) return false;
            if (s.signum() < 1) return false;
            if (r.compareTo(order) >= 0) return false;
            if (s.compareTo(order) >= 0) {
                return false;
            }
            derSignature = EllipticCurveSignatureValidator.transcodeConcatToDER(concatSignature);
            return this.doVerify(sig, publicKey, data, derSignature);
        }
        catch (Exception e) {
            String msg = "Unable to verify Elliptic Curve signature using configured ECPublicKey. " + e.getMessage();
            throw new acscommons.io.jsonwebtoken.security.SignatureException(msg, e);
        }
    }

    protected boolean doVerify(Signature sig, PublicKey publicKey, byte[] data, byte[] signature) throws InvalidKeyException, SignatureException {
        sig.initVerify(publicKey);
        sig.update(data);
        return sig.verify(signature);
    }
}

