/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.impl.crypto;

import acscommons.io.jsonwebtoken.SignatureAlgorithm;
import acscommons.io.jsonwebtoken.impl.crypto.EllipticCurveSignatureValidator;
import acscommons.io.jsonwebtoken.impl.crypto.MacValidator;
import acscommons.io.jsonwebtoken.impl.crypto.RsaSignatureValidator;
import acscommons.io.jsonwebtoken.impl.crypto.SignatureValidator;
import acscommons.io.jsonwebtoken.impl.crypto.SignatureValidatorFactory;
import acscommons.io.jsonwebtoken.lang.Assert;
import java.security.Key;

public class DefaultSignatureValidatorFactory
implements SignatureValidatorFactory {
    public static final SignatureValidatorFactory INSTANCE = new DefaultSignatureValidatorFactory();

    @Override
    public SignatureValidator createSignatureValidator(SignatureAlgorithm alg, Key key) {
        Assert.notNull((Object)alg, "SignatureAlgorithm cannot be null.");
        Assert.notNull(key, "Signing Key cannot be null.");
        switch (alg) {
            case HS256: 
            case HS384: 
            case HS512: {
                return new MacValidator(alg, key);
            }
            case RS256: 
            case RS384: 
            case RS512: 
            case PS256: 
            case PS384: 
            case PS512: {
                return new RsaSignatureValidator(alg, key);
            }
            case ES256: 
            case ES384: 
            case ES512: {
                return new EllipticCurveSignatureValidator(alg, key);
            }
        }
        throw new IllegalArgumentException("The '" + alg.name() + "' algorithm cannot be used for signing.");
    }
}

