/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.impl;

import acscommons.io.jsonwebtoken.MalformedJwtException;
import acscommons.io.jsonwebtoken.io.DeserializationException;
import acscommons.io.jsonwebtoken.io.Deserializer;
import acscommons.io.jsonwebtoken.io.IOException;
import acscommons.io.jsonwebtoken.lang.Assert;
import java.nio.charset.StandardCharsets;

class JwtDeserializer<T>
implements Deserializer<T> {
    static final String MALFORMED_ERROR = "Malformed JWT JSON: ";
    static final String MALFORMED_COMPLEX_ERROR = "Malformed or excessively complex JWT JSON. This could reflect a potential malicious JWT, please investigate the JWT source further. JSON: ";
    private final Deserializer<T> deserializer;

    JwtDeserializer(Deserializer<T> deserializer) {
        Assert.notNull(deserializer, "deserializer cannot be null.");
        this.deserializer = deserializer;
    }

    @Override
    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return this.deserializer.deserialize(bytes);
        }
        catch (DeserializationException e) {
            throw new MalformedJwtException(MALFORMED_ERROR + new String(bytes, StandardCharsets.UTF_8), e);
        }
        catch (StackOverflowError e) {
            throw new IOException(MALFORMED_COMPLEX_ERROR + new String(bytes, StandardCharsets.UTF_8), e);
        }
    }
}

