/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import com.adobe.acs.commons.redirects.models.ExportColumn;
import com.adobe.acs.commons.redirects.models.ImportLog;
import com.adobe.acs.commons.redirects.models.Redirects;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.post.HtmlResponse;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, name="ImportRedirectMapServlet", property={"sling.servlet.label=ACS AEM Commons - Import Redirects Servlet", "sling.servlet.methods=POST", "sling.servlet.selectors=import", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects"})
public class ImportRedirectMapServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ImportRedirectMapServlet.class);
    private static final long serialVersionUID = -3564475196678277711L;
    private static final String MIX_CREATED = "mix:created";
    private static final String MIX_LAST_MODIFIED = "mix:lastModified";
    private static final String AUDIT_LOG_FOLDER = "/var/acs-commons/redirects";
    private static final int SHARD_SIZE = 1000;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Collection<Map<String, Object>> xlsRules;
            Map<String, Resource> jcrRules;
            response.setContentType("application/json");
            String path = request.getParameter("path");
            boolean replace = request.getParameter("replace") != null;
            Resource storageRoot = request.getResourceResolver().getResource(path);
            log.debug("Updating redirect maps at {}", (Object)storageRoot.getPath());
            if (replace) {
                jcrRules = Collections.emptyMap();
                for (Resource ch : storageRoot.getChildren()) {
                    ch.getResourceResolver().delete(ch);
                }
            } else {
                jcrRules = this.getRules(storageRoot);
            }
            ImportLog auditLog = new ImportLog();
            try (InputStream is = ImportRedirectMapServlet.getFile(request);){
                xlsRules = this.readEntries(is, auditLog);
            }
            if (!xlsRules.isEmpty()) {
                this.update(storageRoot, xlsRules, jcrRules);
            }
            this.persistAuditLog(request.getResourceResolver(), auditLog, response.getWriter());
        }
        catch (IOException e) {
            HtmlResponse htmlResponse = new HtmlResponse();
            htmlResponse.setStatus(500, "Failed to import redirects: " + e.getMessage());
            htmlResponse.send((HttpServletResponse)response, true);
        }
    }

    Map<String, Resource> getRules(Resource resource) {
        List<Resource> redirects = Redirects.readRedirects(resource);
        LinkedHashMap<String, Resource> rulesByPathMap = new LinkedHashMap<String, Resource>();
        for (Resource res : redirects) {
            String src = (String)res.getValueMap().get("source", String.class);
            rulesByPathMap.put(src, res);
        }
        return rulesByPathMap;
    }

    void update(Resource root, Collection<Map<String, Object>> xlsRedirects, Map<String, Resource> jcrRedirects) throws PersistenceException {
        ResourceResolver resolver = root.getResourceResolver();
        long t0 = System.currentTimeMillis();
        if (xlsRedirects.size() > 1000) {
            int count = 0;
            for (Map<String, Object> props : xlsRedirects) {
                String shardName = "shard-" + ++count / 1000;
                String sourcePath = (String)props.get("source");
                Resource shard = root.getChild(shardName);
                if (shard == null) {
                    shard = resolver.create(root, shardName, Collections.singletonMap("jcr:primaryType", "nt:unstructured"));
                }
                Resource redirect = this.getOrCreateRedirect(shard, sourcePath, props, jcrRedirects);
                log.trace("rule[{}]: {}", (Object)count, (Object)redirect.getPath());
                if (count % 1000 != 0) continue;
                resolver.commit();
            }
        } else {
            for (Map<String, Object> props : xlsRedirects) {
                String sourcePath = (String)props.get("source");
                Resource redirect = this.getOrCreateRedirect(root, sourcePath, props, jcrRedirects);
                log.trace("rule: {}", (Object)redirect.getPath());
            }
            resolver.commit();
        }
        log.debug("{} rules imported in {}ms", (Object)xlsRedirects.size(), (Object)(System.currentTimeMillis() - t0));
    }

    private Resource getOrCreateRedirect(Resource root, String sourcePath, Map<String, Object> props, Map<String, Resource> jcrRedirects) throws PersistenceException {
        Resource redirect = jcrRedirects.get(sourcePath);
        if (redirect == null) {
            props.put("jcr:mixinTypes", MIX_CREATED);
            props.put("jcr:primaryType", "nt:unstructured");
            String nodeName = ResourceUtil.createUniqueChildName((Resource)root, (String)"redirect-rule-");
            redirect = root.getResourceResolver().create(root, nodeName, props);
        } else {
            ValueMap valueMap = (ValueMap)redirect.adaptTo(ModifiableValueMap.class);
            if (valueMap == null) {
                throw new PersistenceException("Cannot modify properties of " + redirect.getPath());
            }
            String[] mixins = (String[])valueMap.get("jcr:mixinTypes", String[].class);
            HashSet<String> mset = mixins == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(mixins));
            mset.add(MIX_LAST_MODIFIED);
            props.put("jcr:mixinTypes", mset.toArray(new String[0]));
            valueMap.putAll(props);
        }
        return redirect;
    }

    Collection<Map<String, Object>> readEntries(InputStream is, ImportLog auditLog) throws IOException {
        LinkedHashSet<Map<String, Object>> rules = new LinkedHashSet<Map<String, Object>>();
        XSSFWorkbook wb = new XSSFWorkbook(is);
        Sheet sheet = wb.getSheetAt(0);
        Iterator it = sheet.rowIterator();
        if (it.hasNext()) {
            Row headerRow = (Row)it.next();
            Map<ExportColumn, Integer> cols = this.mapColumns(headerRow);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Map<String, Object> props = this.readRedirect(row, cols, auditLog);
                if (props != null) {
                    rules.add(props);
                    continue;
                }
                log.debug("couldn't read redirect properties from row {} ", (Object)row.getRowNum());
            }
        }
        log.debug("{} rules read from spreadsheet", (Object)rules.size());
        return rules;
    }

    Map<ExportColumn, Integer> mapColumns(Row row) {
        LinkedHashMap<ExportColumn, Integer> cols = new LinkedHashMap<ExportColumn, Integer>();
        for (Cell cell : row) {
            if (cell.getColumnIndex() <= 2 || cell.getCellType() != CellType.STRING) continue;
            String title = cell.getStringCellValue();
            for (ExportColumn col : ExportColumn.values()) {
                if (!col.getTitle().equalsIgnoreCase(title)) continue;
                cols.put(col, cell.getColumnIndex());
            }
        }
        return cols;
    }

    private Map<String, Object> readRedirect(Row row, Map<ExportColumn, Integer> cols, ImportLog auditLog) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("sling:resourceType", "acs-commons/components/utilities/manage-redirects/redirect-row");
        Cell c0 = row.getCell(0);
        if (c0 == null || c0.getCellType() != CellType.STRING || c0.toString().isEmpty()) {
            auditLog.warn(new CellReference(row.getRowNum(), 0).formatAsString(), "Cell A is required and should contain redirect source");
            return null;
        }
        Cell c1 = row.getCell(1);
        if (c1 == null || c1.getCellType() != CellType.STRING || c1.toString().isEmpty()) {
            auditLog.warn(new CellReference(row.getRowNum(), 1).formatAsString(), "Cell B is required and should contain redirect source");
            return null;
        }
        Cell c2 = row.getCell(2);
        if (c2 == null || c2.getCellType() != CellType.NUMERIC) {
            auditLog.warn(new CellReference(row.getRowNum(), 2).formatAsString(), "Cell C is required and should contain redirect status code");
            return null;
        }
        String source = c0.getStringCellValue();
        props.put("source", source);
        String target = c1.getStringCellValue();
        props.put("target", target);
        int statusCode = (int)c2.getNumericCellValue();
        props.put("statusCode", String.valueOf(statusCode));
        Map<String, Object> optionalProps = this.readOptionalProperties(row, cols, auditLog);
        props.putAll(optionalProps);
        return props;
    }

    private Map<String, Object> readOptionalProperties(Row row, Map<ExportColumn, Integer> cols, ImportLog auditLog) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (ExportColumn column : ExportColumn.values()) {
            int columnIndex;
            Cell cell;
            if (column.ordinal() < 3 || !column.isImportable() || !cols.containsKey((Object)column) || (cell = row.getCell(columnIndex = cols.get((Object)column).intValue())) == null || cell.getCellType() == CellType.BLANK) continue;
            Object value = null;
            if (column.getPropertyType() == String[].class && cell.getCellType() == CellType.STRING) {
                value = cell.getStringCellValue().split("\n");
            } else if (column.getPropertyType() == String.class && cell.getCellType() == CellType.STRING) {
                value = cell.getStringCellValue();
            } else if (column.getPropertyType() == Boolean.class && cell.getCellType() == CellType.BOOLEAN) {
                value = cell.getBooleanCellValue();
            } else if (column.getPropertyType() == Calendar.class && cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(cell.getDateCellValue());
                value = calendar;
            }
            if (value != null) {
                props.put(column.getPropertyName(), value);
                continue;
            }
            String cellAddress = new CellReference(row.getRowNum(), cell.getColumnIndex()).formatAsString();
            auditLog.info(cellAddress, "Can't set '" + column.getTitle() + "' from a " + cell.getCellType().toString().toLowerCase() + " cell: '" + cell + "'");
        }
        return props;
    }

    private void persistAuditLog(ResourceResolver resourceResolver, ImportLog auditLog, PrintWriter out) throws IOException {
        ObjectMapper om = new ObjectMapper();
        ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)AUDIT_LOG_FOLDER, Collections.singletonMap("jcr:primaryType", "sling:Folder"), (String)"sling:Folder", (boolean)false);
        String auditNodePath = "/var/acs-commons/redirects/" + UUID.randomUUID();
        Resource ntFile = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)auditNodePath, Collections.singletonMap("jcr:primaryType", "nt:file"), null, (boolean)false);
        auditLog.setPath(ntFile.getPath());
        String json = om.writeValueAsString((Object)auditLog);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("jcr:primaryType", "nt:resource");
        props.put("jcr:mixinTypes", MIX_CREATED);
        props.put("jcr:mimeType", "application/json");
        props.put("jcr:data", new ByteArrayInputStream(json.getBytes()));
        ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)(auditNodePath + "/" + "jcr:content"), props, null, (boolean)false);
        resourceResolver.commit();
        out.println(json);
    }

    public static InputStream getFile(SlingHttpServletRequest request) throws IOException {
        InputStream stream = null;
        for (RequestParameter param : request.getRequestParameterList()) {
            if (param.isFormField()) continue;
            stream = param.getInputStream();
            break;
        }
        return stream;
    }
}

