/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.oak.impl.AppliableEnsureOakIndex;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EnsureOakIndexExecutor.class})
public class EnsureOakIndexExecutor {
    private static final Logger log = LoggerFactory.getLogger(EnsureOakIndexExecutor.class);
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.UPDATE)
    private CopyOnWriteArrayList<AppliableEnsureOakIndex> ensureIndexes = new CopyOnWriteArrayList();

    public final int ensureAll(boolean force) {
        log.info("Applying all un-applied ensure index definitions");
        int count = 0;
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            if (!index.isApplied() || force) {
                index.apply(force);
                ++count;
                log.debug("Started applying index definition on [ {} ]", (Object)index);
                continue;
            }
            log.debug("Skipping... [ {} ] is already applied.", (Object)index);
        }
        return count;
    }

    public final int ensure(boolean force, String ensureDefinitionPath) {
        int count = 0;
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            if ((!index.isApplied() || force) && StringUtils.equals((CharSequence)ensureDefinitionPath, (CharSequence)index.getEnsureDefinitionsPath())) {
                index.apply(force);
                ++count;
                log.debug("Started async job applying index definition for {}", (Object)index);
                continue;
            }
            log.debug("Skipping... [ {} ] is already applied.", (Object)index);
        }
        return count;
    }

    protected final void bindAppliableEnsureOakIndex(AppliableEnsureOakIndex index) {
        if (index != null && !this.ensureIndexes.contains(index)) {
            this.ensureIndexes.add(index);
        }
    }

    protected final void unbindAppliableEnsureOakIndex(AppliableEnsureOakIndex index) {
        if (index != null && this.ensureIndexes.contains(index)) {
            this.ensureIndexes.remove(index);
        }
    }

    public final TabularData getEnsureOakIndexes() throws OpenDataException {
        CompositeType configType = new CompositeType("Ensure Oak Index Configurations", "Ensure Oak Index Configurations", new String[]{"Ensure Definitions Path", "Oak Indexes Path", "Applied", "Immediate"}, new String[]{"Ensure Definitions Path", "Oak Indexes Path", "Applied", "Immediate"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Ensure Oak Index Configuration", "Ensure Oak Index Configuration", configType, new String[]{"Ensure Definitions Path", "Oak Indexes Path"}));
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Ensure Definitions Path", index.getEnsureDefinitionsPath());
            data.put("Oak Indexes Path", index.getOakIndexesPath());
            data.put("Applied", index.isApplied());
            data.put("Immediate", index.isImmediate());
            tabularData.put(new CompositeDataSupport(configType, data));
        }
        return tabularData;
    }
}

