/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.day.cq.wcm.api.policies.ContentPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=5500"}, service={Injector.class})
@Designate(ocd=Configuration.class)
public class ContentPolicyValueInjector
implements Injector {
    private static final Logger LOG = LoggerFactory.getLogger(ContentPolicyValueInjector.class);
    Configuration config;

    @Activate
    public void activate(Configuration c) {
        this.config = c;
        LOG.info("ContentPolicyValueInjector {}", (Object)(this.config.enabled() ? "enabled" : "disabled"));
    }

    @NotNull
    public String getName() {
        return "design";
    }

    @Nullable
    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (!this.config.enabled()) {
            return null;
        }
        ContentPolicy policy = InjectorUtils.getContentPolicy(adaptable);
        if (policy != null) {
            return ReflectionUtil.convertValueMapValue(policy.getProperties(), name, declaredType);
        }
        return null;
    }

    @ObjectClassDefinition(name="ACS AEM Commons ContentPolicyValueInjector")
    public static @interface Configuration {
        @AttributeDefinition(name="enabled")
        public boolean enabled() default true;
    }
}

