/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.acs.commons.contentsync.CatalogItem;
import com.adobe.acs.commons.contentsync.UpdateStrategy;
import com.adobe.acs.commons.contentsync.servlet.ContentCatalogServlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class}, property={"job.topics=acs-commons/contentsync"})
public class ContentCatalogJobConsumer
implements JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final transient Map<String, UpdateStrategy> updateStrategies = Collections.synchronizedMap(new LinkedHashMap());
    public static final String SERVICE_NAME = "content-sync";
    public static final String JOB_TOPIC = "acs-commons/contentsync";
    @Reference
    ResourceResolverFactory resourceResolverFactory;

    @Reference(service=UpdateStrategy.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindDeltaStrategy(UpdateStrategy strategy) {
        if (strategy != null) {
            String key = strategy.getClass().getName();
            this.updateStrategies.put(key, strategy);
        }
    }

    protected void unbindDeltaStrategy(UpdateStrategy strategy) {
        String key = strategy.getClass().getName();
        this.updateStrategies.remove(key);
    }

    public JobExecutionResult process(Job job, JobExecutionContext context) {
        String pid = (String)job.getProperty("strategy");
        UpdateStrategy updateStrategy = this.getStrategy(pid);
        try {
            log.debug("processing {}, pid: {}", (Object)job.getId(), (Object)pid);
            Map<String, Object> jobProperties = job.getPropertyNames().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((Job)job).getProperty(arg_0)));
            List<CatalogItem> items = updateStrategy.getItems(jobProperties);
            JsonArrayBuilder resources = Json.createArrayBuilder();
            for (CatalogItem item : items) {
                resources.add((JsonValue)item.getJsonObject());
            }
            JsonObjectBuilder result = Json.createObjectBuilder();
            result.add("resources", resources);
            this.save(result.build(), job);
        }
        catch (Exception e) {
            log.error("content-sync job failed: {}", (Object)job.getId(), (Object)e);
            return context.result().message(e.getMessage()).cancelled();
        }
        return context.result().succeeded();
    }

    UpdateStrategy getStrategy(String pid) {
        UpdateStrategy strategy;
        if (pid == null) {
            strategy = this.updateStrategies.values().iterator().next();
        } else {
            strategy = this.updateStrategies.get(pid);
            if (strategy == null) {
                throw new IllegalArgumentException("Cannot find UpdateStrategy for pid " + pid + ". Available strategies: " + this.updateStrategies.values().stream().map(s -> s.getClass().getName()).collect(Collectors.toList()));
            }
        }
        return strategy;
    }

    String save(JsonObject result, Job job) throws RepositoryException, LoginException, PersistenceException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (JsonWriter out = Json.createWriter((OutputStream)bout);){
            out.writeObject(result);
        }
        Map<String, String> authInfo = Collections.singletonMap("sling.service.subservice", SERVICE_NAME);
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(authInfo);){
            String resultsPath = ContentCatalogServlet.getJobResultsPath(job.getId());
            String resultsParent = ResourceUtil.getParent((String)resultsPath);
            String resultsNode = ResourceUtil.getName((String)resultsPath);
            Node parentNode = JcrUtils.getOrCreateByPath((String)resultsParent, (String)"nt:folder", (String)"nt:folder", (Session)((Session)resolver.adaptTo(Session.class)), (boolean)false);
            Node ntFile = JcrUtils.putFile((Node)parentNode, (String)resultsNode, (String)"application/json", (InputStream)new ByteArrayInputStream(bout.toByteArray()), (Calendar)Calendar.getInstance());
            log.debug(ntFile.getPath());
            resolver.commit();
            String string = ntFile.getPath();
            return string;
        }
    }
}

