/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.acs.commons.contentsync.impl.LastModifiedStrategy;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class ConfigurationUtils {
    public static final String CONFIG_PATH = "/var/acs-commons/contentsync";
    public static final String SETTINGS_PATH = "/var/acs-commons/contentsync/settings";
    public static final String HOSTS_PATH = "/var/acs-commons/contentsync/hosts";
    public static final String UPDATE_STRATEGY_KEY = "update-strategy";
    public static final String EVENT_USER_DATA_KEY = "event-user-data";
    public static final String SO_TIMEOUT_STRATEGY_KEY = "soTimeout";
    public static final String CONNECT_TIMEOUT_KEY = "connTimeout";
    public static final String DISABLE_CERT_CHECK_KEY = "disableCertCheck";

    private ConfigurationUtils() {
    }

    public static Resource getSettingsResource(ResourceResolver resourceResolver) throws PersistenceException {
        HashMap<String, Object> resourceProperties = new HashMap<String, Object>();
        resourceProperties.put("jcr:primaryType", "nt:unstructured");
        resourceProperties.put(UPDATE_STRATEGY_KEY, LastModifiedStrategy.class.getName());
        resourceProperties.put(EVENT_USER_DATA_KEY, "changedByPageManagerCopy");
        resourceProperties.put(SO_TIMEOUT_STRATEGY_KEY, 300000);
        resourceProperties.put(CONNECT_TIMEOUT_KEY, 5000);
        return ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)SETTINGS_PATH, resourceProperties, (String)"sling:Folder", (boolean)true);
    }

    public static Resource getHostsResource(ResourceResolver resourceResolver) throws PersistenceException {
        HashMap<String, String> resourceProperties = new HashMap<String, String>();
        resourceProperties.put("jcr:primaryType", "nt:unstructured");
        return ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)HOSTS_PATH, resourceProperties, (String)"sling:Folder", (boolean)true);
    }

    public static void persistAuditLog(ResourceResolver resourceResolver, String path, long count, String data) throws PersistenceException {
        String auditHome = "/var/acs-commons/contentsync/audit";
        ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)auditHome, Collections.singletonMap("jcr:primaryType", "nt:unstructured"), (String)"nt:folder", (boolean)false);
        HashMap<String, Object> auditProps = new HashMap<String, Object>();
        auditProps.put("jcr:primaryType", "nt:unstructured");
        auditProps.put("syncPath", path);
        auditProps.put("jcr:mixinTypes", "mix:created");
        auditProps.put("count", count);
        String auditResourcePath = auditHome + "/" + UUID.randomUUID();
        ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)auditResourcePath, auditProps, null, (boolean)false);
        String auditLogPath = auditResourcePath + "/log";
        ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)auditLogPath, Collections.singletonMap("jcr:primaryType", "nt:file"), null, (boolean)false);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("jcr:primaryType", "nt:resource");
        props.put("jcr:mimeType", "text/plain");
        props.put("jcr:data", new ByteArrayInputStream(data.getBytes()));
        ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)(auditLogPath + "/" + "jcr:content"), props, null, (boolean)false);
        resourceResolver.commit();
    }
}

