/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.impl.crypto;

import acscommons.io.jsonwebtoken.SignatureAlgorithm;
import acscommons.io.jsonwebtoken.impl.crypto.EllipticCurveSigner;
import acscommons.io.jsonwebtoken.impl.crypto.MacSigner;
import acscommons.io.jsonwebtoken.impl.crypto.RsaSigner;
import acscommons.io.jsonwebtoken.impl.crypto.Signer;
import acscommons.io.jsonwebtoken.impl.crypto.SignerFactory;
import acscommons.io.jsonwebtoken.lang.Assert;
import java.security.Key;

public class DefaultSignerFactory
implements SignerFactory {
    public static final SignerFactory INSTANCE = new DefaultSignerFactory();

    @Override
    public Signer createSigner(SignatureAlgorithm alg, Key key) {
        Assert.notNull((Object)alg, "SignatureAlgorithm cannot be null.");
        Assert.notNull(key, "Signing Key cannot be null.");
        switch (alg) {
            case HS256: 
            case HS384: 
            case HS512: {
                return new MacSigner(alg, key);
            }
            case RS256: 
            case RS384: 
            case RS512: 
            case PS256: 
            case PS384: 
            case PS512: {
                return new RsaSigner(alg, key);
            }
            case ES256: 
            case ES384: 
            case ES512: {
                return new EllipticCurveSigner(alg, key);
            }
        }
        throw new IllegalArgumentException("The '" + alg.name() + "' algorithm cannot be used for signing.");
    }
}

