/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.servlets;

import com.adobe.acs.commons.json.JsonObjectUtil;
import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"resume"}, extensions={"json"})
public class ResumeServlet
extends SlingAllMethodsServlet {
    @Reference
    private transient BulkWorkflowEngine bulkWorkflowEngine;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JsonObject params = JsonObjectUtil.toJsonObject(request.getParameter("params"));
        Config config = (Config)request.getResource().adaptTo(Config.class);
        int throttle = JsonObjectUtil.getInteger(params, "throttle", -1);
        int interval = JsonObjectUtil.getInteger(params, "interval", -1);
        if (throttle > -1) {
            config.setThrottle(throttle);
            config.commit();
        } else if (interval > -1) {
            config.setInterval(interval);
            config.commit();
        }
        this.bulkWorkflowEngine.resume(config);
        response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, request.getResource().getPath()) + ".status.json");
    }

    protected void bindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        this.bulkWorkflowEngine = bulkWorkflowEngine;
    }

    protected void unbindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        if (this.bulkWorkflowEngine == bulkWorkflowEngine) {
            this.bulkWorkflowEngine = null;
        }
    }
}

