/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Delegating Servlet", description="Delegating Servlet enabling the unobtrusive delegate of Resource Types.", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, immediate=false)
@Properties(value={@Property(label="Source Resource Types", description="Requests matching the \"Source resource types, selectors, extensions and methods\" will be overlayed using the \"Target Resource Type\"", name="sling.servlet.resourceTypes", cardinality=0x7FFFFFFF, value={""}), @Property(label="Source Selectors", description="Requests matching the \"Source resource types, selectors, extensions and methods\" will be overlayed using the \"Target Resource Type\"", name="sling.servlet.selectors", cardinality=0x7FFFFFFF, value={""}), @Property(label="Source Extensions", description="Requests matching the \"Source resource types, selectors, extensions and methods\" will be overlayed using the \"Target Resource Type\"", name="sling.servlet.extensions", cardinality=0x7FFFFFFF, value={"html"}), @Property(label="Source HTTP Methods", description="Requests matching the \"Source resource types, selectors, extensions and methods\" will be overlayed using the \"Target Resource Type\"", name="sling.servlet.methods", cardinality=0x7FFFFFFF, value={"GET"}), @Property(name="webconsole.configurationFactory.nameHint", value={"Target type: {prop.target-resource-type}"})})
@Service(value={Servlet.class})
public final class DelegatingServletFactoryImpl
extends SlingAllMethodsServlet {
    protected static final Logger log = LoggerFactory.getLogger(DelegatingServletFactoryImpl.class);
    private static final String REQUEST_ATTR_DELEGATION_HISTORY = DelegatingServletFactoryImpl.class.getName() + "_History";
    private static final String DEFAULT_TARGET_RESOURCE_TYPE = "";
    private String targetResourceType = "";
    @Property(label="Target Resource Type", description="The resource type to proxy requests to.", value={""})
    public static final String PROP_TARGET_RESOURCE_TYPE = "prop.target-resource-type";

    public void doGeneric(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    public void doHead(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    public void doOptions(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    public void doTrace(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    public void doDelete(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    public void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    public void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.delegate(request, response);
    }

    private void delegate(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        if (this.isCyclic(request, this.targetResourceType)) {
            log.error("Delegation Servlet creating a cycle for Target Resource Type: {}", (Object)this.targetResourceType);
            throw new ServletException("Cyclic delegation detected for " + this.targetResourceType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetResourceType)) {
            log.debug("Delegating Request resource type with: {}", (Object)this.targetResourceType);
            options.setForceResourceType(this.targetResourceType);
        } else {
            log.warn("Delegating Servlet's \"Target Resource Type\" is blank or null");
        }
        try {
            this.setDelegationHistory(request, this.targetResourceType);
            request.getRequestDispatcher(request.getResource(), options).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            log.error("Could not properly re-route request to delegate resource type: {}", (Object)this.targetResourceType);
        }
        catch (IOException e) {
            log.error("Could not properly re-route request to delegate resource type: {}", (Object)this.targetResourceType);
        }
    }

    private boolean isCyclic(SlingHttpServletRequest request, String targetResourceType) {
        if (StringUtils.isBlank((CharSequence)targetResourceType)) {
            log.debug("Delegating Servlet's \"Target Resource Type\" is blank or null");
            return true;
        }
        Set<String> history = this.getDelegationHistory(request);
        if (history.contains(targetResourceType)) {
            log.debug("Delegating Servlet's \"Target Resource Type\" is been forwarded to previously");
            return true;
        }
        return false;
    }

    private Set<String> getDelegationHistory(SlingHttpServletRequest request) {
        HashSet<String> history = new HashSet<String>();
        Object tmp = request.getAttribute(REQUEST_ATTR_DELEGATION_HISTORY);
        if (history.getClass().isInstance(tmp)) {
            return (Set)tmp;
        }
        return history;
    }

    private void setDelegationHistory(SlingHttpServletRequest request, String targetResourceType) {
        Set<String> history = this.getDelegationHistory(request);
        history.add(targetResourceType);
        request.setAttribute(REQUEST_ATTR_DELEGATION_HISTORY, history);
    }

    @Activate
    protected void activate(Map<String, String> config) {
        this.targetResourceType = PropertiesUtil.toString((Object)config.get(PROP_TARGET_RESOURCE_TYPE), (String)DEFAULT_TARGET_RESOURCE_TYPE);
        if (StringUtils.isBlank((CharSequence)this.targetResourceType)) {
            throw new IllegalArgumentException("Target Resource Type must NOT be blank");
        }
        log.debug("Target Resource Type: {}", (Object)this.targetResourceType);
    }
}

