/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.sorter.impl;

import com.adobe.acs.commons.sorter.NodeSorter;
import com.adobe.acs.commons.sorter.impl.HierarchyNodeComparator;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;

@Component
public class NodeNameSorter
implements NodeSorter {
    public static final String SORTER_NAME = "byName";
    public static final String RP_CASE_SENSITIVE = ":caseSensitive";
    public static final String RP_RESPECT_NUMBERS = ":respectNumbers";
    private Comparator<Node> numbersFirstComparator = (n1, n2) -> {
        try {
            String name1 = n1.getName();
            String name2 = n2.getName();
            return Boolean.compare(StringUtils.isNumeric((CharSequence)name2), StringUtils.isNumeric((CharSequence)name1));
        }
        catch (RepositoryException e) {
            return 0;
        }
    };

    @Override
    public String getName() {
        return SORTER_NAME;
    }

    @Override
    public String getLabel() {
        return "By Node Name";
    }

    @Override
    public Comparator<Node> createComparator(HttpServletRequest request) {
        boolean caseSensitive = Boolean.parseBoolean(request.getParameter(RP_CASE_SENSITIVE));
        boolean respectNumbers = Boolean.parseBoolean(request.getParameter(RP_RESPECT_NUMBERS));
        boolean nonHierarchyFirst = request.getParameter(":nonHierarchyFirst") == null || Boolean.parseBoolean(request.getParameter(":nonHierarchyFirst"));
        Comparator<Node> comparator = (n1, n2) -> 0;
        if (nonHierarchyFirst) {
            comparator = comparator.thenComparing(HierarchyNodeComparator.INSTANCE);
        }
        if (respectNumbers) {
            comparator = comparator.thenComparing(this.numbersFirstComparator);
        }
        comparator = comparator.thenComparing((n1, n2) -> {
            try {
                String name1 = n1.getName();
                String name2 = n2.getName();
                if (respectNumbers && StringUtils.isNumeric((CharSequence)name1) && StringUtils.isNumeric((CharSequence)name2)) {
                    Integer number1 = Integer.valueOf(name1);
                    Integer number2 = Integer.valueOf(name2);
                    return number1.compareTo(number2);
                }
                return caseSensitive ? name1.compareTo(name2) : name1.compareToIgnoreCase(name2);
            }
            catch (RepositoryException e) {
                return 0;
            }
        });
        return comparator;
    }
}

