/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.adobe.acs.commons.reports.internal.DelimiterConfiguration;
import com.adobe.acs.commons.reports.internal.ExporterUtil;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class TagReportCellCSVExporter
implements ReportCellCSVExporter {
    private static final Logger log = LoggerFactory.getLogger(TagReportCellCSVExporter.class);
    @OSGiService
    private DelimiterConfiguration delimiterConfiguration;
    @ValueMapValue
    private String property;

    public TagReportCellCSVExporter() {
    }

    TagReportCellCSVExporter(DelimiterConfiguration delimiterConfiguration) {
        this.delimiterConfiguration = delimiterConfiguration;
    }

    @Override
    public String getValue(Object result) {
        String relativePropertyPath = ExporterUtil.relativizePath(this.property);
        Resource resource = (Resource)result;
        TagManager tagMgr = (TagManager)resource.getResourceResolver().adaptTo(TagManager.class);
        log.debug("Loading tags from {}@{}", (Object)resource.getPath(), (Object)relativePropertyPath);
        ArrayList<String> tags = new ArrayList<String>();
        String[] values = (String[])resource.getValueMap().get(relativePropertyPath, String[].class);
        if (values != null) {
            for (String value : values) {
                tags.add(Optional.ofNullable(tagMgr).map(tm -> tm.resolve(value).getTitle()).orElse(value));
            }
        }
        log.debug("Loaded {} tags", tags);
        return StringUtils.join(tags, (String)this.delimiterConfiguration.getMultiValueDelimiter());
    }
}

