/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.replication.status.ReplicationStatusManager;
import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.replication.Replicator;
import java.util.Calendar;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class PageReplicationStatusModel
implements ReportCellCSVExporter {
    private static final Logger log = LoggerFactory.getLogger(PageReplicationStatusModel.class);
    @OSGiService
    private Replicator replicator;
    @OSGiService
    private ReplicationStatusManager replicationStatusManager;
    @Self
    private Resource resource;

    private Calendar getLastModified(ResourceResolver resourceResolver, String pageContentPath) {
        Resource pageContent = resourceResolver.getResource(pageContentPath);
        Calendar lastModified = null;
        if (pageContent != null) {
            lastModified = (Calendar)pageContent.getValueMap().get("cq:lastModified", Calendar.class);
        }
        return lastModified;
    }

    private String getReplicationStatus(Resource targetResource) {
        Resource replicationResource = this.replicationStatusManager.getReplicationStatusResource(targetResource.getPath(), targetResource.getResourceResolver());
        log.debug("Getting replication status for {}", (Object)replicationResource.getPath());
        ReplicationStatus status = (ReplicationStatus)replicationResource.adaptTo(ReplicationStatus.class);
        Status rStatus = Status.NOT_ACTIVATED;
        if (status != null) {
            if (status.isDeactivated()) {
                rStatus = Status.DEACTIVATED;
            } else if (status.isPending()) {
                rStatus = Status.IN_PROGRESS;
            } else if (status.isActivated()) {
                Calendar lastModified = this.getLastModified(targetResource.getResourceResolver(), replicationResource.getPath());
                rStatus = lastModified != null && status.getLastPublished() != null && lastModified.after(status.getLastPublished()) ? Status.MODIFIED : Status.ACTIVATED;
            }
        }
        log.debug("Retrieved replication status {}", (Object)rStatus);
        return rStatus.toString();
    }

    public String getReplicationStatus() {
        return this.getReplicationStatus(this.resource);
    }

    @Override
    public String getValue(Object result) {
        if (result instanceof Resource) {
            return this.getReplicationStatus((Resource)result);
        }
        return "UNKNOWN";
    }

    public static enum Status {
        ACTIVATED,
        DEACTIVATED,
        IN_PROGRESS,
        MODIFIED,
        NOT_ACTIVATED;

    }
}

