/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.internal;

import acscommons.com.google.common.collect.ImmutableList;
import com.adobe.acs.commons.reports.models.PredictedTag;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredictedTagsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PredictedTagsUtil.class);
    public static final double MINIMUM_LOWER_CONFIDENCE_THRESHOLD_VALUE = 0.0;

    public List<PredictedTag> getPredictedTags(Resource resource, String relativePropertyPath, Double lowerConfidenceThreshold) {
        double validatedLowerConfidenceValue = this.validateLowerConfidenceThreshold(lowerConfidenceThreshold);
        if (resource == null) {
            LOGGER.error("getPredictedTags : The given resource is null, hence returning empty list.");
            return Collections.emptyList();
        }
        Asset asset = this.resolveToAsset(resource);
        if (asset == null) {
            LOGGER.warn("getPredictedTags : The given resource could not be resolved to an asset, hence returning empty list.");
            return Collections.emptyList();
        }
        Resource predictedTagsResource = this.getPredictedTagsResource(resource, asset, relativePropertyPath);
        if (predictedTagsResource == null) {
            LOGGER.info("getPredictedTags : No predicted tags found at the property path, hence returning empty list.");
            return Collections.emptyList();
        }
        ImmutableList<Resource> predictedTagResources = ImmutableList.copyOf(predictedTagsResource.getChildren());
        ArrayList<PredictedTag> predictedTags = new ArrayList<PredictedTag>();
        for (Resource predictedTagResource : predictedTagResources) {
            PredictedTag predictedTag = (PredictedTag)predictedTagResource.adaptTo(PredictedTag.class);
            if (predictedTag == null || !(predictedTag.getConfidence() >= validatedLowerConfidenceValue)) continue;
            predictedTags.add(predictedTag);
        }
        this.sortByConfidence(predictedTags);
        LOGGER.debug("getPredictedTags : Loaded predictedTags {}.", predictedTagResources);
        return predictedTags;
    }

    protected void sortByConfidence(List<PredictedTag> tagList) {
        tagList.sort((p1, p2) -> {
            double p1Confidence = p1 != null ? p1.getConfidence() : 0.0;
            double p2Confidence = p2 != null ? p2.getConfidence() : 0.0;
            return -Double.compare(p1Confidence, p2Confidence);
        });
    }

    public Asset resolveToAsset(Resource resource) {
        return DamUtil.resolveToAsset((Resource)resource);
    }

    protected Resource getPredictedTagsResource(Resource resource, Asset asset, String relativePropertyPath) {
        String predictedTagsPath;
        if (resource == null || asset == null) {
            return null;
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        Resource predictedTagsResource = resourceResolver.getResource(predictedTagsPath = StringUtils.isNotBlank((CharSequence)relativePropertyPath) ? PathUtil.append((String)resource.getPath(), (String)relativePropertyPath) : resource.getPath());
        if (predictedTagsResource == null) {
            predictedTagsPath = PathUtil.append((String)asset.getPath(), (String)"jcr:content/metadata/predictedTags");
            return resourceResolver.getResource(predictedTagsPath);
        }
        return predictedTagsResource;
    }

    protected double validateLowerConfidenceThreshold(Double lowerConfidenceThresholdValue) {
        return lowerConfidenceThresholdValue != null && !lowerConfidenceThresholdValue.isNaN() && !lowerConfidenceThresholdValue.isInfinite() && lowerConfidenceThresholdValue >= 0.0 ? lowerConfidenceThresholdValue : 0.0;
    }
}

