/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.impl;

import com.adobe.acs.commons.replication.ReplicateVersion;
import com.adobe.acs.commons.replication.ReplicationResult;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.AgentIdFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class ReplicateVersionImpl
implements ReplicateVersion {
    private static final Logger log = LoggerFactory.getLogger(ReplicateVersionImpl.class);
    @Reference
    private transient Replicator replicator;

    @Override
    public final List<ReplicationResult> replicate(ResourceResolver resolver, String[] rootPaths, String[] agents, Date date) {
        ArrayList<ReplicationResult> list = new ArrayList<ReplicationResult>();
        if (rootPaths != null) {
            for (String rootPath : rootPaths) {
                String normalizedPath = this.getNormalizedPath(rootPath);
                List<Resource> resources = this.getResources(resolver, normalizedPath);
                List<ReplicationResult> resultsForPath = this.replicateResource(resolver, resources, agents, date);
                list.addAll(resultsForPath);
            }
        }
        return list;
    }

    private List<Resource> getResources(ResourceResolver resolver, String root) {
        Resource res = resolver.getResource(root);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            this.buildResourceList(resolver, res, resources);
        }
        catch (RepositoryException e) {
            log.error("exception occured", (Throwable)e);
        }
        return resources;
    }

    private void buildResourceList(ResourceResolver resolver, Resource res, List<Resource> resources) throws RepositoryException {
        Node node = (Node)res.adaptTo(Node.class);
        if (!node.isNodeType("nt:hierarchyNode")) {
            return;
        }
        resources.add(res);
        Iterator iter = resolver.listChildren(res);
        while (iter.hasNext()) {
            Resource resChild = (Resource)iter.next();
            this.buildResourceList(resolver, resChild, resources);
        }
    }

    private List<ReplicationResult> replicateResource(ResourceResolver resolver, List<Resource> resources, String[] agents, Date date) {
        ArrayList<ReplicationResult> results = new ArrayList<ReplicationResult>();
        ReplicationOptions opts = new ReplicationOptions();
        AgentIdFilter agentFilter = new AgentIdFilter(agents);
        opts.setFilter((AgentFilter)agentFilter);
        Session session = (Session)resolver.adaptTo(Session.class);
        for (Resource resource : resources) {
            String path = resource.getPath();
            try {
                Version v = this.getAppropriateVersion(resource, date, session);
                if (v == null) {
                    results.add(new ReplicationResult(path, ReplicationResult.Status.not_replicated));
                    continue;
                }
                String versionName = v.getName();
                opts.setRevision(versionName);
                this.replicator.replicate(session, ReplicationActionType.ACTIVATE, path, opts);
                results.add(new ReplicationResult(path, ReplicationResult.Status.replicated, versionName));
            }
            catch (RepositoryException e) {
                results.add(new ReplicationResult(path, ReplicationResult.Status.error));
                log.error("Exception while replicating version of " + path, (Throwable)e);
            }
            catch (ReplicationException e) {
                results.add(new ReplicationResult(path, ReplicationResult.Status.error));
                log.error("Exception while replicating version of " + path, (Throwable)e);
            }
        }
        return results;
    }

    private Version getAppropriateVersion(Resource resource, Date date, Session session) throws RepositoryException {
        String path = resource.getPath();
        List<Version> versions = this.findAllVersions(path, session);
        Collections.sort(versions, (v1, v2) -> {
            try {
                return v2.getCreated().compareTo(v1.getCreated());
            }
            catch (RepositoryException e) {
                return 0;
            }
        });
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        for (Version v : versions) {
            try {
                if (v.getCreated().compareTo(cal) >= 1) continue;
                return v;
            }
            catch (RepositoryException e) {
                log.error("exception occured", (Throwable)e);
            }
        }
        return null;
    }

    private List<Version> findAllVersions(String path, Session session) throws RepositoryException {
        List<Version> versions = new ArrayList<Version>();
        Node node = session.getNode(path);
        if (node.hasNode("jcr:content")) {
            Node contentNode = node.getNode("jcr:content");
            if (contentNode.isNodeType("mix:versionable")) {
                versions = this.getVersions(contentNode.getPath(), session);
            } else if (node.isNodeType("mix:versionable")) {
                versions = this.getVersions(path, session);
            }
        }
        return versions;
    }

    private List<Version> getVersions(String nodePath, Session session) throws RepositoryException {
        ArrayList<Version> versions = new ArrayList<Version>();
        VersionIterator iter = session.getWorkspace().getVersionManager().getVersionHistory(nodePath).getAllVersions();
        while (iter.hasNext()) {
            Version v = iter.nextVersion();
            versions.add(v);
        }
        return versions;
    }

    private String getNormalizedPath(String path) {
        String root = path;
        if (root == null || "".equals(root)) {
            return null;
        }
        while (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        if (root.length() == 0) {
            root = "/";
        }
        return root;
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }
}

