/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.oak.EnsureOakIndexManager;
import com.adobe.acs.commons.oak.impl.AppliableEnsureOakIndex;
import com.adobe.acs.commons.oak.impl.EnsureOakIndexManagerMBean;
import com.adobe.acs.commons.util.RequireAem;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DynamicMBean.class, EnsureOakIndexManager.class}, immediate=true, property={"felix.webconsole.title=Ensure Oak Index", "felix.webconsole.label=ensureOakIndex", "felix.webconsole.category=Sling", "jmx.objectname=com.adobe.acs.commons.oak:type=Ensure Oak Index"})
@Designate(ocd=Config.class)
public class EnsureOakIndexManagerImpl
extends AnnotatedStandardMBean
implements EnsureOakIndexManager,
EnsureOakIndexManagerMBean {
    private static final Logger log = LoggerFactory.getLogger(EnsureOakIndexManagerImpl.class);
    private static final String[] DEFAULT_ADDITIONAL_IGNORE_PROPERTIES = new String[0];
    private String[] additionalIgnoreProperties = DEFAULT_ADDITIONAL_IGNORE_PROPERTIES;
    public static final String PROP_ADDITIONAL_IGNORE_PROPERTIES = "properties.ignore";
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.UPDATE)
    private CopyOnWriteArrayList<AppliableEnsureOakIndex> ensureIndexes = new CopyOnWriteArrayList();

    public EnsureOakIndexManagerImpl() throws NotCompliantMBeanException {
        super(EnsureOakIndexManagerMBean.class);
    }

    @Override
    public final int ensureAll(boolean force) {
        log.info("Applying all un-applied ensure index definitions");
        int count = 0;
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            if (!index.isApplied() || force) {
                index.apply(force);
                ++count;
                log.debug("Started applying index definition on [ {} ]", (Object)index);
                continue;
            }
            log.debug("Skipping... [ {} ] is already applied.", (Object)index);
        }
        return count;
    }

    @Override
    public final int ensure(boolean force, String ensureDefinitionPath) {
        int count = 0;
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            if ((!index.isApplied() || force) && StringUtils.equals((CharSequence)ensureDefinitionPath, (CharSequence)index.getEnsureDefinitionsPath())) {
                index.apply(force);
                ++count;
                log.debug("Started async job applying index definition for {}", (Object)index);
                continue;
            }
            log.debug("Skipping... [ {} ] is already applied.", (Object)index);
        }
        return count;
    }

    protected final void bindAppliableEnsureOakIndex(AppliableEnsureOakIndex index) {
        if (index != null && !this.ensureIndexes.contains(index)) {
            this.ensureIndexes.add(index);
        }
    }

    protected final void unbindAppliableEnsureOakIndex(AppliableEnsureOakIndex index) {
        if (index != null && this.ensureIndexes.contains(index)) {
            this.ensureIndexes.remove(index);
        }
    }

    @Override
    public final TabularData getEnsureOakIndexes() throws OpenDataException {
        CompositeType configType = new CompositeType("Ensure Oak Index Configurations", "Ensure Oak Index Configurations", new String[]{"Ensure Definitions Path", "Oak Indexes Path", "Applied", "Immediate"}, new String[]{"Ensure Definitions Path", "Oak Indexes Path", "Applied", "Immediate"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Ensure Oak Index Configuration", "Ensure Oak Index Configuration", configType, new String[]{"Ensure Definitions Path", "Oak Indexes Path"}));
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Ensure Definitions Path", index.getEnsureDefinitionsPath());
            data.put("Oak Indexes Path", index.getOakIndexesPath());
            data.put("Applied", index.isApplied());
            data.put("Immediate", index.isImmediate());
            tabularData.put(new CompositeDataSupport(configType, data));
        }
        return tabularData;
    }

    @Activate
    protected void activate(Config config) {
        this.additionalIgnoreProperties = config.properties_ignore();
    }

    protected String[] getIgnoredProperties() {
        return Optional.ofNullable(this.additionalIgnoreProperties).map(array -> Arrays.copyOf(array, ((String[])array).length)).orElse(DEFAULT_ADDITIONAL_IGNORE_PROPERTIES);
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Ensure Oak Index Manager", description="Manage for ensuring oak indexes.")
    static @interface Config {
        @AttributeDefinition(name="Additional ignore properties", description="Property names that are to be ignored when determining if an oak index has changed, as well as what properties should be removed/updated.", cardinality=0x7FFFFFFF)
        public String[] properties_ignore() default {};

        public String webconsole_configurationFactory_nameHint() default "Additional Ignore properties: {properties.ignore}";
    }
}

