/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public abstract class AbstractJSONObjectVisitor {
    private int currentDepth = 0;

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public void accept(JsonObject jsonObject) {
        if (jsonObject != null) {
            this.visit(jsonObject);
            ++this.currentDepth;
            this.traverseJSONObject(jsonObject);
            --this.currentDepth;
        }
    }

    public void accept(JsonArray jsonArray) {
        if (jsonArray != null) {
            ++this.currentDepth;
            this.traverseJSONArray(jsonArray);
            --this.currentDepth;
        }
    }

    protected final void traverseJSONObject(JsonObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        for (Map.Entry elem : jsonObject.entrySet()) {
            if (((JsonElement)elem.getValue()).isJsonArray()) {
                this.accept(((JsonElement)elem.getValue()).getAsJsonArray());
                continue;
            }
            if (!((JsonElement)elem.getValue()).isJsonObject()) continue;
            this.accept(((JsonElement)elem.getValue()).getAsJsonObject());
        }
    }

    protected final void traverseJSONArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (jsonArray.get(i).isJsonObject()) {
                this.accept(jsonArray.get(i).getAsJsonObject());
                continue;
            }
            if (!jsonArray.get(i).isJsonArray()) continue;
            this.accept(jsonArray.get(i).getAsJsonArray());
        }
    }

    protected abstract void visit(JsonObject var1);
}

