/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl.keys;

import acscommons.com.google.common.base.Objects;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.keys.AbstractCacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.day.cq.commons.PathInfo;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;

public class RequestPathCacheKey
extends AbstractCacheKey
implements CacheKey {
    private static final long serialVersionUID = 1L;
    private final String selector;
    private final String extension;

    public RequestPathCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) {
        super(request, cacheConfig);
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        this.selector = pathInfo.getSelectorString();
        this.extension = pathInfo.getExtension();
    }

    public RequestPathCacheKey(String uri, HttpCacheConfig cacheConfig) {
        super(uri, cacheConfig);
        PathInfo pathInfo = new PathInfo(uri);
        this.selector = pathInfo.getSelectorString();
        this.extension = pathInfo.getExtension();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPathCacheKey that = (RequestPathCacheKey)o;
        return Objects.equal(this.getSelector(), that.getSelector()) && Objects.equal(this.getExtension(), that.getExtension()) && Objects.equal(this.getResourcePath(), that.getResourcePath());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getSelector(), this.getExtension(), this.getResourcePath());
    }

    @Override
    public String toString() {
        return this.resourcePath + "." + this.selector + "." + this.extension;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getExtension() {
        return this.extension;
    }
}

