/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import com.adobe.acs.commons.dam.ColorConversion;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.InputStream;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Component(label="ACS AEM Commons - Color Conversion", description="ACS AEM Commons - Color Conversion", metatype=true)
@Service
public final class ColorConversionImpl
implements ColorConversion {
    private static final String DEFAULT_CMYK_PROFILE = "JapanColor2001Coated";
    @Property(label="CMYK ICC Profile", description="ICC Profile for CMYK to RGB Conversion", value={"JapanColor2001Coated"}, options={@PropertyOption(name="CoatedFOGRA27", value="CoatedFOGRA27"), @PropertyOption(name="CoatedFOGRA39", value="CoatedFOGRA39"), @PropertyOption(name="JapanColor2001Coated", value="JapanColor2001Coated"), @PropertyOption(name="JapanColor2001Uncoated", value="JapanColor2001Uncoated"), @PropertyOption(name="JapanColor2002Newspaper", value="JapanColor2002Newspaper"), @PropertyOption(name="JapanWebCoated", value="JapanWebCoated"), @PropertyOption(name="UncoatedFOGRA29", value="UncoatedFOGRA29"), @PropertyOption(name="USSheetfedCoated", value="USSheetfedCoated"), @PropertyOption(name="USSheetfedUncoated", value="USSheetfedUncoated"), @PropertyOption(name="USWebCoatedSWOP", value="USWebCoatedSWOP"), @PropertyOption(name="USWebUncoated", value="USWebUncoated"), @PropertyOption(name="WebCoatedFOGRA28", value="WebCoatedFOGRA28")})
    private static final String PROP_CMKY_PROFILE = "cmyk.icc.profile";
    private static final double[][] xyzTosRgbMatrix = new double[][]{{3.2406, -1.5372, -0.4986}, {-0.9689, 1.8758, 0.0415}, {0.0557, -0.204, 1.057}};
    private ColorSpace cmykColorSpace;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        String profileName = PropertiesUtil.toString((Object)properties.get(PROP_CMKY_PROFILE), (String)DEFAULT_CMYK_PROFILE);
        InputStream iccData = this.getClass().getClassLoader().getResourceAsStream("icc/cmyk/" + profileName + ".icc");
        ICC_Profile profile = ICC_Profile.getInstance(iccData);
        this.cmykColorSpace = new ICC_ColorSpace(profile);
    }

    @Override
    public ColorConversion.RGB toRGB(ColorConversion.CMYK cymk) {
        float[] input = new float[]{(float)cymk.cyan / 100.0f, (float)cymk.magenta / 100.0f, (float)cymk.yellow / 100.0f, (float)cymk.black / 100.0f};
        float[] output = this.cmykColorSpace.toRGB(input);
        ColorConversion.RGB rgb = new ColorConversion.RGB(Math.round(output[0] * 255.0f), Math.round(output[1] * 255.0f), Math.round(output[2] * 255.0f));
        return rgb;
    }

    @Override
    public ColorConversion.RGB toRGB(ColorConversion.LAB lab) {
        XYZ xyz = this.toXYZ(lab);
        double x = xyz.x / 100.0;
        double y = xyz.y / 100.0;
        double z = xyz.z / 100.0;
        double r = x * xyzTosRgbMatrix[0][0] + y * xyzTosRgbMatrix[0][1] + z * xyzTosRgbMatrix[0][2];
        double g = x * xyzTosRgbMatrix[1][0] + y * xyzTosRgbMatrix[1][1] + z * xyzTosRgbMatrix[1][2];
        double b = x * xyzTosRgbMatrix[2][0] + y * xyzTosRgbMatrix[2][1] + z * xyzTosRgbMatrix[2][2];
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : (r *= 12.92);
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : (g *= 12.92);
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : (b *= 12.92);
        r = r < 0.0 ? 0.0 : r;
        g = g < 0.0 ? 0.0 : g;
        b = b < 0.0 ? 0.0 : b;
        ColorConversion.RGB rgb = new ColorConversion.RGB((int)Math.round(r * 255.0), (int)Math.round(g * 255.0), (int)Math.round(b * 255.0));
        return rgb;
    }

    private XYZ toXYZ(ColorConversion.LAB lab) {
        double y = ((double)lab.lightness + 16.0) / 116.0;
        double y3 = Math.pow(y, 3.0);
        double x = (double)lab.a / 500.0 + y;
        double x3 = Math.pow(x, 3.0);
        double z = y - (double)lab.b / 200.0;
        double z3 = Math.pow(z, 3.0);
        y = y3 > 0.008856 ? y3 : (y - 0.13793103448275862) / 7.787;
        x = x3 > 0.008856 ? x3 : (x - 0.13793103448275862) / 7.787;
        z = z3 > 0.008856 ? z3 : (z - 0.13793103448275862) / 7.787;
        XYZ result = new XYZ();
        result.x = x * 95.0429;
        result.y = y * 100.0;
        result.z = z * 108.89;
        return result;
    }

    private class XYZ {
        private double x;
        private double y;
        private double z;

        private XYZ() {
        }
    }
}

