/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.audio.watson.impl;

import com.adobe.acs.commons.dam.audio.watson.impl.TranscriptionService;
import com.adobe.acs.commons.http.HttpClientFactory;
import com.adobe.acs.commons.http.JsonObjectResponseHandler;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class TranscriptionServiceImpl
implements TranscriptionService {
    private static final Logger log = LoggerFactory.getLogger(TranscriptionServiceImpl.class);
    private static final JsonObjectResponseHandler HANDLER = new JsonObjectResponseHandler();
    @Reference(target="(factory.name=watson-speech-to-text)")
    private HttpClientFactory httpClientFactory;

    @Override
    public String startTranscriptionJob(InputStream stream, String mimeType) {
        Request request = this.httpClientFactory.post("/speech-to-text/api/v1/recognitions?continuous=true&timestamps=true").addHeader("Content-Type", mimeType).bodyStream(stream);
        try {
            JsonObject json = (JsonObject)this.httpClientFactory.getExecutor().execute(request).handleResponse((ResponseHandler)HANDLER);
            Gson gson = new Gson();
            log.trace("content: {}", (Object)gson.toJson((JsonElement)json));
            return json.get("id").getAsString();
        }
        catch (IOException e) {
            log.error("error submitting job", (Throwable)e);
            return null;
        }
    }

    @Override
    public TranscriptionService.Result getResult(String jobId) {
        log.debug("getting result for {}", (Object)jobId);
        Request request = this.httpClientFactory.get("/speech-to-text/api/v1/recognitions/" + jobId);
        try {
            JsonObject json = (JsonObject)this.httpClientFactory.getExecutor().execute(request).handleResponse((ResponseHandler)HANDLER);
            Gson gson = new Gson();
            log.trace("content: {}", (Object)gson.toJson((JsonElement)json));
            if (json.has("status") && json.get("status").getAsString().equals("completed")) {
                JsonArray results = json.get("results").getAsJsonArray().get(0).getAsJsonObject().get("results").getAsJsonArray();
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < results.size(); ++i) {
                    JsonObject firstAlternative;
                    String line;
                    JsonObject result = results.get(i).getAsJsonObject();
                    if (!result.get("final").getAsBoolean() || !StringUtils.isNotBlank((CharSequence)(line = (firstAlternative = result.get("alternatives").getAsJsonArray().get(0).getAsJsonObject()).get("transcript").getAsString()))) continue;
                    double firstTimestamp = firstAlternative.get("timestamps").getAsJsonArray().get(0).getAsJsonArray().get(1).getAsDouble();
                    builder.append("[").append(firstTimestamp).append("s]: ").append(line).append("\n");
                }
                String concatenated = builder.toString();
                concatenated = concatenated.replace("%HESITATION ", "");
                return new ResultImpl(true, concatenated);
            }
            return new ResultImpl(false, null);
        }
        catch (IOException e) {
            log.error("Unable to get result. assuming failure.", (Throwable)e);
            return new ResultImpl(true, "error");
        }
    }

    protected void bindHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    protected void unbindHttpClientFactory(HttpClientFactory httpClientFactory) {
        if (this.httpClientFactory == httpClientFactory) {
            this.httpClientFactory = null;
        }
    }

    private static class ResultImpl
    implements TranscriptionService.Result {
        private final boolean completed;
        private final String content;

        public ResultImpl(boolean completed, String content) {
            this.completed = completed;
            this.content = content;
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }

        @Override
        public String getContent() {
            return this.content;
        }
    }
}

