/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync.impl;

import com.adobe.acs.commons.contentsync.CatalogItem;
import com.adobe.acs.commons.contentsync.UpdateStrategy;
import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.day.cq.commons.PathInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class LastModifiedStrategy
implements UpdateStrategy {
    public static final String DEFAULT_GET_SERVLET = "org.apache.sling.servlets.get.DefaultGetServlet";
    public static final String REDIRECT_SERVLET = "org.apache.sling.servlets.get.impl.RedirectServlet";
    @Reference
    private ServletResolver servletResolver;

    @Override
    public List<CatalogItem> getItems(final SlingHttpServletRequest request) {
        String rootPath = request.getParameter("root");
        if (rootPath == null) {
            throw new IllegalArgumentException("root request parameter is required");
        }
        boolean nonRecursive = "false".equals(request.getParameter("recursive"));
        Resource root = request.getResourceResolver().getResource(rootPath);
        if (root == null) {
            return Collections.emptyList();
        }
        final ArrayList<CatalogItem> items = new ArrayList<CatalogItem>();
        if (nonRecursive) {
            JsonObjectBuilder json = Json.createObjectBuilder();
            this.writeMetadata(json, root, request);
            items.add(new CatalogItem(json.build()));
        } else {
            new AbstractResourceVisitor(){

                public void visit(Resource res) {
                    if (!LastModifiedStrategy.this.accepts(res)) {
                        return;
                    }
                    JsonObjectBuilder json = Json.createObjectBuilder();
                    LastModifiedStrategy.this.writeMetadata(json, res, request);
                    items.add(new CatalogItem(json.build()));
                }
            }.accept(root);
        }
        return items;
    }

    @Override
    public boolean isModified(CatalogItem remoteResource, Resource localResource) {
        LastModifiedInfo remoteLastModified = this.getLastModified(remoteResource);
        LastModifiedInfo localLastModified = this.getLastModified(localResource);
        return remoteLastModified.getLastModified() > localLastModified.getLastModified();
    }

    @Override
    public String getMessage(CatalogItem remoteResource, Resource localResource) {
        LastModifiedInfo remoteLastModified = this.getLastModified(remoteResource);
        LastModifiedInfo localLastModified = this.getLastModified(localResource);
        boolean modified = remoteLastModified.getLastModified() > localLastModified.getLastModified();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy, h:mm:ss a");
        StringBuilder msg = new StringBuilder();
        if (localResource == null) {
            msg.append("resource does not exist");
        } else {
            msg.append(modified ? "resource modified ... " : "replacing ... ");
            if (localLastModified.getLastModified() > 0L) {
                msg.append('\n');
                msg.append("\tlocal lastModified: " + dateFormat.format(localLastModified.getLastModified()) + " by " + localLastModified.getLastModifiedBy());
            }
            if (remoteLastModified.getLastModified() > 0L) {
                msg.append('\n');
                msg.append("\tremote lastModified: " + dateFormat.format(remoteLastModified.getLastModified()) + " by " + remoteLastModified.getLastModifiedBy());
            }
        }
        return msg.toString();
    }

    boolean accepts(Resource resource) {
        return !resource.getPath().contains("/jcr:content") && !resource.getPath().contains("/rep:");
    }

    String getJsonRendererServlet(SlingHttpServletRequest slingRequest, final String urlPath) {
        final Resource resource = slingRequest.getResourceResolver().resolve(urlPath);
        Servlet s = this.servletResolver.resolveServlet((SlingHttpServletRequest)new SlingHttpServletRequestWrapper(slingRequest){

            public Resource getResource() {
                return resource;
            }

            public String getMethod() {
                return "GET";
            }

            public RequestPathInfo getRequestPathInfo() {
                return new PathInfo(urlPath);
            }
        });
        String servletName = null;
        if (s instanceof GenericServlet) {
            GenericServlet genericServlet = (GenericServlet)s;
            servletName = genericServlet.getServletName();
        }
        if (REDIRECT_SERVLET.equals(servletName)) {
            servletName = DEFAULT_GET_SERVLET;
        }
        return servletName;
    }

    void writeMetadata(JsonObjectBuilder jw, Resource res, SlingHttpServletRequest request) {
        String exportUri;
        Resource contentResource;
        jw.add("path", res.getPath());
        jw.add("jcr:primaryType", (String)res.getValueMap().get("jcr:primaryType", String.class));
        Resource jcrContent = res.getChild("jcr:content");
        if (jcrContent != null) {
            contentResource = jcrContent;
            exportUri = jcrContent.getPath() + ".infinity.json";
        } else {
            contentResource = res;
            exportUri = res.getPath() + ".json";
        }
        String renderServlet = this.getJsonRendererServlet(request, exportUri);
        if (!DEFAULT_GET_SERVLET.equals(renderServlet)) {
            contentResource = contentResource.getParent();
            exportUri = contentResource.getPath() + ".infinity.json";
        }
        if (!DEFAULT_GET_SERVLET.equals(renderServlet = this.getJsonRendererServlet(request, exportUri))) {
            jw.add("renderServlet", renderServlet);
        }
        jw.add("exportUri", exportUri);
        LastModifiedInfo lastModified = this.getLastModified(res);
        if (lastModified.getLastModified() > 0L) {
            jw.add("lastModified", lastModified.getLastModified());
        }
        if (lastModified.getLastModifiedBy() != null) {
            jw.add("lastModifiedBy", lastModified.getLastModifiedBy());
        }
    }

    private LastModifiedInfo getLastModified(CatalogItem item) {
        long lastModified = item.getLong("lastModified");
        String lastModifiedBy = item.getString("lastModifiedBy");
        return new LastModifiedInfo(lastModified, lastModifiedBy);
    }

    private LastModifiedInfo getLastModified(Resource targetResource) {
        long lastModified = 0L;
        String lastModifiedBy = null;
        if (targetResource != null) {
            String modifiedBy;
            ValueMap vm;
            Calendar c;
            Resource contentResource = targetResource.getChild("jcr:content");
            if (contentResource == null) {
                contentResource = targetResource;
            }
            if ((c = (Calendar)(vm = contentResource.getValueMap()).get("cq:lastModified", Calendar.class)) == null) {
                c = (Calendar)vm.get("jcr:lastModified", Calendar.class);
            }
            if (c != null) {
                lastModified = c.getTime().getTime();
            }
            if ((modifiedBy = (String)vm.get("cq:lastModifiedBy", String.class)) == null) {
                modifiedBy = (String)vm.get("jcr:lastModifiedBy", String.class);
            }
            lastModifiedBy = AuthorizableUtil.getFormattedName((ResourceResolver)targetResource.getResourceResolver(), (String)modifiedBy);
        }
        return new LastModifiedInfo(lastModified, lastModifiedBy);
    }

    private static class LastModifiedInfo {
        private final long lastModified;
        private final String lastModifiedBy;

        public LastModifiedInfo(long lastModified, String lastModifiedBy) {
            this.lastModified = lastModified;
            this.lastModifiedBy = lastModifiedBy;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String getLastModifiedBy() {
            return this.lastModifiedBy;
        }
    }
}

