/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.audit_log_search;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

public class AuditLogSearchRequest {
    private static final FastDateFormat HTML5_DATETIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm", (TimeZone)TimeZone.getTimeZone("GMT"));
    private static final FastDateFormat QUERY_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss", (TimeZone)TimeZone.getTimeZone("GMT"));
    private final String contentRoot;
    private final boolean includeChildren;
    private final String type;
    private final String user;
    private final Date startDate;
    private final Date endDate;
    private final String order;
    private Map<String, String> userNames = new HashMap<String, String>();
    private Map<String, String> userPaths = new HashMap<String, String>();

    private static String getJcrSqlDate(Date date) {
        return QUERY_DATE_FORMAT.format(date) + ".000Z";
    }

    public AuditLogSearchRequest(SlingHttpServletRequest request) throws ParseException {
        this.contentRoot = request.getParameter("contentRoot");
        this.includeChildren = "true".equals(request.getParameter("includeChildren"));
        this.type = request.getParameter("type");
        this.user = request.getParameter("user");
        this.startDate = this.loadDate(request.getParameter("startDate"));
        this.endDate = this.loadDate(request.getParameter("endDate"));
        this.order = request.getParameter("order");
    }

    public String getContentRoot() {
        return this.contentRoot;
    }

    public Date getEndDate() {
        return Optional.ofNullable(this.endDate).map(date -> (Date)date.clone()).orElse(null);
    }

    public String getOrder() {
        return this.order;
    }

    public String getQueryParameters() {
        ArrayList<String> expressions = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)this.type)) {
            expressions.add("[cq:type]='" + StringUtils.replace((String)this.type, (String)"'", (String)"''") + "'");
        }
        if (!StringUtils.isEmpty((CharSequence)this.user)) {
            expressions.add("[cq:userid]='" + StringUtils.replace((String)this.user, (String)"'", (String)"''") + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.contentRoot)) {
            if (this.includeChildren) {
                expressions.add("[cq:path] LIKE '" + StringUtils.replace((String)this.contentRoot, (String)"'", (String)"''") + "%'");
            } else {
                expressions.add("[cq:path]='" + StringUtils.replace((String)this.contentRoot, (String)"'", (String)"''") + "'");
            }
        }
        if (this.startDate != null) {
            expressions.add("[cq:time] > CAST('" + AuditLogSearchRequest.getJcrSqlDate(this.startDate) + "' AS DATE)");
        }
        if (this.endDate != null) {
            expressions.add("[cq:time] < CAST('" + AuditLogSearchRequest.getJcrSqlDate(this.endDate) + "' AS DATE)");
        }
        String query = StringUtils.join(expressions, (String)" AND ");
        if (!StringUtils.isEmpty((CharSequence)this.order)) {
            query = query + " ORDER BY " + this.order;
        }
        return query;
    }

    public Date getStartDate() {
        return Optional.ofNullable(this.startDate).map(date -> (Date)date.clone()).orElse(null);
    }

    public String getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public String getUserName(ResourceResolver resolver, String userId) throws RepositoryException {
        if (!this.userNames.containsKey(userId)) {
            UserPropertiesManager upm = (UserPropertiesManager)resolver.adaptTo(UserPropertiesManager.class);
            UserProperties userProperties = upm.getUserProperties(userId, "profiles/private");
            String name = userId;
            if (userProperties != null && !StringUtils.isEmpty((CharSequence)userProperties.getDisplayName())) {
                name = userProperties.getDisplayName();
            }
            this.userNames.put(userId, name);
        }
        return this.userNames.get(userId);
    }

    public String getUserPath(ResourceResolver resolver, String userId) throws UnsupportedRepositoryOperationException, RepositoryException {
        Authorizable usr;
        UserManager userManager;
        if (!this.userPaths.containsKey(userId) && (userManager = (UserManager)resolver.adaptTo(UserManager.class)) != null && (usr = userManager.getAuthorizable(userId)) != null) {
            this.userPaths.put(userId, usr.getPath());
        }
        return this.userPaths.get(userId);
    }

    public boolean isIncludehildren() {
        return this.includeChildren;
    }

    private Date loadDate(String dateStr) throws ParseException {
        Date date = null;
        if (!StringUtils.isEmpty((CharSequence)dateStr)) {
            date = HTML5_DATETIME_FORMAT.parse(dateStr);
        }
        return date;
    }

    public String toString() {
        return "AuditLogSearchRequest [contentRoot=" + this.contentRoot + ", includeChildren=" + this.includeChildren + ", type=" + this.type + ", user=" + this.user + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", order=" + this.order + ", userNames=" + this.userNames + ", userPaths=" + this.userPaths + "]";
    }
}

