/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.status.impl;

import com.adobe.acs.commons.replication.status.ReplicationStatusManager;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class ReplicationStatusManagerImpl
implements ReplicationStatusManager {
    private static final Logger log = LoggerFactory.getLogger(ReplicationStatusManagerImpl.class);
    public static final String DEFAULT_REPLICATED_BY = "Unknown";
    private static final String REP_STATUS_ACTIVATE = "Activate";
    private static final String REP_STATUS_DEACTIVATE = "Deactivate";
    private static final int SAVE_THRESHOLD = 1024;

    @Override
    public Resource getReplicationStatusResource(String path, ResourceResolver resourceResolver) {
        Resource resource;
        String type;
        Page page = ((PageManager)resourceResolver.adaptTo(PageManager.class)).getContainingPage(path);
        Asset asset = DamUtil.resolveToAsset((Resource)resourceResolver.getResource(path));
        if (page != null) {
            type = "Page";
            resource = page.getContentResource();
        } else if (asset != null) {
            type = "Asset";
            Resource assetResource = resourceResolver.getResource(asset.getPath());
            resource = assetResource.getChild("jcr:content");
        } else {
            type = "Resource";
            resource = resourceResolver.getResource(path);
        }
        log.trace("{}'s resource that tracks replication status is {}", (Object)type, (Object)resource.getPath());
        return resource;
    }

    @Override
    public final void setReplicationStatus(ResourceResolver resourceResolver, String replicatedBy, Calendar replicatedAt, ReplicationStatusManager.Status status, String ... paths) throws RepositoryException, PersistenceException {
        this.setReplicationStatus(resourceResolver, Collections.emptySet(), replicatedBy, replicatedAt, status, paths);
    }

    @Override
    public final void setReplicationStatus(ResourceResolver resourceResolver, Collection<String> agentIds, String replicatedBy, Calendar replicatedAt, ReplicationStatusManager.Status status, String ... paths) throws RepositoryException, PersistenceException {
        for (String path : paths) {
            Resource resource = resourceResolver.getResource(path);
            if (resource == null) {
                log.warn("Requesting a replication status update for a resource that does not exist: {}", (Object)path);
                continue;
            }
            this.setReplicationStatus(resourceResolver, replicatedBy, replicatedAt, status, resource);
        }
    }

    @Override
    public final void setReplicationStatus(ResourceResolver resourceResolver, String replicatedBy, Calendar replicatedAt, ReplicationStatusManager.Status status, Resource ... resources) throws RepositoryException, PersistenceException {
        this.setReplicationStatus(resourceResolver, Collections.emptySet(), replicatedBy, replicatedAt, status, resources);
    }

    @Override
    public final void setReplicationStatus(ResourceResolver resourceResolver, Collection<String> agentIds, String replicatedBy, Calendar replicatedAt, ReplicationStatusManager.Status status, Resource ... resources) throws RepositoryException, PersistenceException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        Calendar replicatedAtClean = replicatedAt;
        if (replicatedAtClean == null) {
            replicatedAtClean = Calendar.getInstance();
            log.warn("The provided [ replicatedAt ] parameter is null. Force setting the [ {} ] value to [ {} ]", (Object)"cq:lastReplicated", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(replicatedAtClean.getTime()));
        }
        String replicatedByClean = replicatedBy;
        if (replicatedBy == null) {
            replicatedByClean = DEFAULT_REPLICATED_BY;
            log.warn("The provided [ replicatedBy ] parameter is null. Force setting the [ {} ] value to [ {} ]", (Object)"cq:lastReplicatedBy", (Object)replicatedByClean);
        }
        int count = 0;
        for (Resource resource : resources) {
            Node node = (Node)resource.adaptTo(Node.class);
            if (ReplicationStatusManager.Status.CLEAR.equals((Object)status)) {
                this.setReplicationStatus(node, agentIds, null, null, null);
                if (!node.isNodeType("cq:ReplicationStatus")) {
                    this.removeReplicationStatusMixin(node);
                }
            } else {
                String replicationStatus;
                String string = replicationStatus = ReplicationStatusManager.Status.ACTIVATED.equals((Object)status) ? REP_STATUS_ACTIVATE : REP_STATUS_DEACTIVATE;
                if (!node.isNodeType("cq:ReplicationStatus")) {
                    this.addReplicationStatusMixin(node);
                }
                this.setReplicationStatus(node, agentIds, replicatedAtClean, replicatedByClean, replicationStatus);
            }
            log.debug("Updated replication status for resource [ {} ] to [ {} ].", (Object)resource.getPath(), (Object)status.name());
            if (count++ <= 1024) continue;
            session.save();
            count = 0;
        }
        if (count > 0) {
            session.save();
        }
    }

    private void setReplicationStatus(Node node, Collection<String> agentIds, Calendar replicatedAt, String replicatedBy, String replicationStatus) throws RepositoryException {
        Set propertyNameSuffixes = Stream.concat(Stream.of(""), agentIds.stream().map(s -> "_" + s)).collect(Collectors.toSet());
        for (String propertyNameSuffix : propertyNameSuffixes) {
            JcrUtil.setProperty((Node)node, (String)("cq:lastReplicated" + propertyNameSuffix), (Object)replicatedAt);
            JcrUtil.setProperty((Node)node, (String)("cq:lastReplicatedBy" + propertyNameSuffix), (Object)replicatedBy);
            JcrUtil.setProperty((Node)node, (String)("cq:lastReplicationAction" + propertyNameSuffix), (Object)replicationStatus);
        }
    }

    @Override
    public final void clearReplicationStatus(ResourceResolver resourceResolver, Resource ... resources) throws RepositoryException, PersistenceException {
        this.setReplicationStatus(resourceResolver, null, null, ReplicationStatusManager.Status.CLEAR, resources);
    }

    private void addReplicationStatusMixin(Node node) throws RepositoryException {
        if (!this.hasMixin(node, "cq:ReplicationStatus") && node.canAddMixin("cq:ReplicationStatus")) {
            node.addMixin("cq:ReplicationStatus");
        }
    }

    private void removeReplicationStatusMixin(Node node) throws RepositoryException {
        if (this.hasMixin(node, "cq:ReplicationStatus")) {
            node.removeMixin("cq:ReplicationStatus");
        }
    }

    private boolean hasMixin(Node node, String mixin) throws RepositoryException {
        if (StringUtils.isBlank((String)mixin)) {
            return false;
        }
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!StringUtils.equals((String)nodeType.getName(), (String)mixin)) continue;
            return true;
        }
        return false;
    }
}

