/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.views.impl;

import com.adobe.acs.commons.util.CookieUtil;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - WCM Views Filter", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="sling.filter.scope", value={"component"}, propertyPrivate=true), @Property(name="filter.order", intValue={-500}, propertyPrivate=true)})
@Service
public class WCMViewsFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WCMViewsFilter.class);
    public static final int FILTER_ORDER = -500;
    public static final String COOKIE_WCM_VIEWS = "acs-commons.wcm-views";
    public static final String PN_WCM_VIEWS = "wcmViews";
    public static final String RP_WCM_VIEWS = "wcm-views";
    public static final String WCM_VIEW_DISABLED = "disabled";
    private static final String ATTR_FILTER = WCMViewsFilter.class.getName() + ".first-wcmmode";
    private String[] includePathPrefixes = new String[]{"/content"};
    @Property(label="Path Prefixes to Include", description="Include paths that begin with these path prefixes. Default: [ /content ]", cardinality=0x7FFFFFFF, value={"/content"})
    public static final String PROP_PATH_PREFIXES_INCLUDE = "path-prefixes.include";
    private List<Pattern> resourceTypesIncludes = new ArrayList<Pattern>();
    @Property(label="Resource Types (Regex)", description="Resource types to apply WCM Views rules to. Leave blank for all. Default: [ <Blank> ]", cardinality=0x7FFFFFFF, value={})
    public static final String PROP_RESOURCE_TYPES_INCLUDE = "resource-types.include";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        WCMMode requestMode = this.getOrSetFirstWCMMode(slingRequest);
        List<String> requestViews = this.getRequestViews(slingRequest);
        List<String> componentViews = this.getComponentViews(slingRequest);
        if (!this.accepts(slingRequest)) {
            log.trace("WCM Filters does NOT accept [ {} ]", (Object)slingRequest.getResource().getPath());
            chain.doFilter(request, response);
        } else if (CollectionUtils.isEmpty(requestViews) && CollectionUtils.isNotEmpty(componentViews) || CollectionUtils.isNotEmpty(requestViews) && CollectionUtils.isEmpty(componentViews) || CollectionUtils.isNotEmpty(requestViews) && CollectionUtils.isNotEmpty(componentViews) && !CollectionUtils.containsAny(requestViews, componentViews)) {
            log.trace("WCMView Empty/Not Empty -- Setting WCMMode [ {} ] for [ {} ]", (Object)WCMMode.DISABLED.name(), (Object)slingRequest.getResource().getPath());
            this.processChain((ServletRequest)slingRequest, response, chain, WCMMode.DISABLED, requestMode);
        } else if (CollectionUtils.containsAny(requestViews, componentViews)) {
            log.debug("WCMView Match -- Setting WCMMode [ {} ] for [ {} ]", (Object)requestMode.name(), (Object)slingRequest.getResource().getPath());
            this.processChain((ServletRequest)slingRequest, response, chain, requestMode, requestMode);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void processChain(ServletRequest request, ServletResponse response, FilterChain chain, WCMMode before, WCMMode after) throws IOException, ServletException {
        before.toRequest(request);
        chain.doFilter(request, response);
        after.toRequest(request);
    }

    private boolean accepts(SlingHttpServletRequest request) {
        PageManager pageManager = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
        Resource resource = request.getResource();
        if (ArrayUtils.isEmpty((Object[])this.includePathPrefixes) || !StringUtils.startsWithAny((String)request.getResource().getPath(), (String[])this.includePathPrefixes)) {
            return false;
        }
        if (this.getRequestViews(request).contains(WCM_VIEW_DISABLED)) {
            return false;
        }
        if (pageManager.getContainingPage(request.getResource()) == null) {
            return false;
        }
        Node node = (Node)request.getResource().adaptTo(Node.class);
        if (node != null) {
            try {
                if (node.isNodeType("cq:Page") || node.isNodeType("cq:PageContent") || "jcr:content".equals(node.getName())) {
                    return false;
                }
            }
            catch (RepositoryException e) {
                log.error("Repository exception prevented WCM Views Filter from determining if the resource is acceptable", (Throwable)e);
                return false;
            }
        }
        if (CollectionUtils.isNotEmpty(this.resourceTypesIncludes)) {
            for (Pattern pattern : this.resourceTypesIncludes) {
                Matcher matcher = pattern.matcher(resource.getResourceType());
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private WCMMode getOrSetFirstWCMMode(SlingHttpServletRequest request) {
        WCMMode wcmMode = (WCMMode)request.getAttribute(ATTR_FILTER);
        if (wcmMode == null) {
            wcmMode = WCMMode.fromRequest((ServletRequest)request);
            request.setAttribute(ATTR_FILTER, (Object)wcmMode);
        }
        return wcmMode;
    }

    private List<String> getRequestViews(SlingHttpServletRequest request) {
        ArrayList<String> views = new ArrayList<String>();
        RequestParameter[] requestParameters = request.getRequestParameters(RP_WCM_VIEWS);
        if (requestParameters != null) {
            for (RequestParameter requestParameter : requestParameters) {
                if (!StringUtils.isNotBlank((String)requestParameter.getString())) continue;
                views.add(requestParameter.getString());
            }
        }
        if (CollectionUtils.isNotEmpty(views)) {
            return views;
        }
        Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, COOKIE_WCM_VIEWS);
        if (cookie != null && StringUtils.isNotBlank((String)cookie.getValue())) {
            views.add(cookie.getValue());
        }
        return views;
    }

    private List<String> getComponentViews(SlingHttpServletRequest request) {
        HashSet<String> views = new HashSet<String>();
        Resource resource = request.getResource();
        if (resource == null) {
            return new ArrayList<String>(views);
        }
        com.day.cq.wcm.api.components.Component component = WCMUtils.getComponent((Resource)resource);
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        if (component != null) {
            views.addAll(Arrays.asList((String[])component.getProperties().get(PN_WCM_VIEWS, (Object)new String[0])));
        }
        if (properties != null) {
            views.addAll(Arrays.asList((String[])properties.get(PN_WCM_VIEWS, (Object)new String[0])));
        }
        return new ArrayList<String>(views);
    }

    @Activate
    protected final void activate(Map<String, String> properties) throws Exception {
        String[] includes = PropertiesUtil.toStringArray((Object)properties.get(PROP_RESOURCE_TYPES_INCLUDE), (String[])new String[0]);
        this.resourceTypesIncludes = new ArrayList<Pattern>();
        for (String include : includes) {
            if (!StringUtils.isNotBlank((String)include)) continue;
            this.resourceTypesIncludes.add(Pattern.compile(include));
        }
        this.includePathPrefixes = PropertiesUtil.toStringArray((Object)properties.get(PROP_PATH_PREFIXES_INCLUDE), (String[])new String[0]);
    }
}

