/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="ACS AEM Commons - OSGI Component Disabler", description="Disables components by configuration", policy=ConfigurationPolicy.REQUIRE)
@Service
@Property(name="event.topics", value={"org/osgi/framework/BundleEvent/STARTED", "org/osgi/framework/ServiceEvent/REGISTERED"}, propertyPrivate=true)
public class ComponentDisabler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(ComponentDisabler.class);
    @Property(label="Disabled components", description="The names of the components/services you want to disable", cardinality=0x7FFFFFFF)
    private static final String DISABLED_COMPONENTS = "components";
    private String[] disabledComponents;
    @Reference
    private ServiceComponentRuntime scr;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.disabledComponents = PropertiesUtil.toStringArray((Object)properties.get(DISABLED_COMPONENTS), (String[])new String[0]);
        this.bundleContext = bundleContext;
        this.handleEvent(null);
    }

    public void handleEvent(Event event) {
        log.trace("Disabling components and services {}", (Object)Arrays.toString(this.disabledComponents));
        for (String component : this.disabledComponents) {
            this.disable(component);
        }
    }

    public void disable(String componentName) {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            ComponentDescriptionDTO dto = this.scr.getComponentDescriptionDTO(bundle, componentName);
            if (dto == null || !this.scr.isComponentEnabled(dto)) continue;
            log.info("Component {} disabled by configuration.", (Object)dto.implementationClass);
            this.scr.disableComponent(dto);
        }
    }

    protected void bindScr(ServiceComponentRuntime serviceComponentRuntime) {
        this.scr = serviceComponentRuntime;
    }

    protected void unbindScr(ServiceComponentRuntime serviceComponentRuntime) {
        if (this.scr == serviceComponentRuntime) {
            this.scr = null;
        }
    }
}

