/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingException;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingNode;
import com.adobe.acs.commons.mcp.impl.processes.renovator.ReplicatorQueue;
import com.adobe.acs.commons.mcp.impl.processes.renovator.Util;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovingAsset
extends MovingNode {
    private static final Logger LOG = LoggerFactory.getLogger(MovingAsset.class);
    private static final String DEFAULT_LAST_MODIFIED_BY = "Renovator";

    @Override
    public boolean isCopiedBeforeMove() {
        return false;
    }

    @Override
    public boolean isSupposedToBeReferenced() {
        return true;
    }

    @Override
    public boolean isAbleToHaveChildren() {
        return false;
    }

    @Override
    protected boolean isAuditableMove() {
        return true;
    }

    @Override
    public void move(ReplicatorQueue replicatorQueue, ResourceResolver rr) throws IllegalAccessException, MovingException {
        Session session = (Session)rr.adaptTo(Session.class);
        try {
            Node originalAssetJcrContentNode;
            session.getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
            session.move(this.getSourcePath(), this.getDestinationPath());
            session.save();
            if (Util.resourceExists(rr, this.getDestinationPath()) && (originalAssetJcrContentNode = session.getNode(this.getDestinationPath() + "/" + "jcr:content")) != null) {
                JcrUtil.setProperty((Node)originalAssetJcrContentNode, (String)"jcr:lastModified", (Object)new Date());
                JcrUtil.setProperty((Node)originalAssetJcrContentNode, (String)"jcr:lastModifiedBy", (Object)DEFAULT_LAST_MODIFIED_BY);
            }
            this.updateReferences(replicatorQueue, rr);
        }
        catch (RepositoryException e) {
            throw new MovingException(this.getSourcePath(), e);
        }
    }

    void updateReferences(ReplicatorQueue rep, ResourceResolver rr) {
        this.getAllReferences().forEach(ref -> this.updateReferences(rep, rr, (String)ref));
    }

    void updateReferences(ReplicatorQueue rep, ResourceResolver rr, String ref) {
        Session session = (Session)rr.adaptTo(Session.class);
        try {
            session.refresh(true);
        }
        catch (RepositoryException e1) {
            LOG.error("RepositoryException", (Object)ref, (Object)e1);
        }
        rr.refresh();
        Resource res = rr.getResource(ref);
        ModifiableValueMap map = (ModifiableValueMap)res.adaptTo(ModifiableValueMap.class);
        AtomicBoolean changedProperty = new AtomicBoolean(false);
        AtomicBoolean changedMultiValuedProperty = new AtomicBoolean(false);
        map.forEach((key, val) -> {
            if (val != null && val.equals(this.getSourcePath())) {
                map.put(key, (Object)this.getDestinationPath());
                changedProperty.set(true);
            } else if (val instanceof Object[]) {
                this.updateMultiValuedReferences((String)key, val, session, map, changedMultiValuedProperty, ref);
            }
        });
        for (Resource child : res.getChildren()) {
            if (child.isResourceType("cq:Page")) continue;
            this.updateReferences(rep, rr, child.getPath());
        }
        try {
            if (changedProperty.get() || changedMultiValuedProperty.get()) {
                rep.replicate(null, ReplicationActionType.ACTIVATE, ref);
            }
        }
        catch (ReplicationException ex) {
            LOG.error("Cannot replicate '{}'", (Object)ref, (Object)ex);
        }
    }

    void updateMultiValuedReferences(String key, Object val, Session session, ModifiableValueMap map, AtomicBoolean changedMultiValuedProperty, String ref) {
        Object[] valList = (Object[])val;
        for (int index = 0; index < valList.length; ++index) {
            Object itm = valList[index];
            if (!itm.equals(this.getSourcePath())) continue;
            valList[index] = this.getDestinationPath();
            changedMultiValuedProperty.set(true);
            map.put((Object)key, (Object)valList);
        }
        if (changedMultiValuedProperty.get()) {
            try {
                session.getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
                session.refresh(true);
                session.save();
            }
            catch (RepositoryException e) {
                LOG.error("RepositoryException", (Object)ref, (Object)e);
            }
        }
    }
}

