/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.data.Variant;
import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.util.IntrospectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingScriptHelper;

public abstract class FieldComponent {
    private String name;
    private FormField formField;
    private AccessibleObject accessibleObject;
    private SlingScriptHelper sling;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String resourceType = "granite/ui/components/coral/foundation/form/textfield";
    private String resourceSuperType = "granite/ui/components/coral/foundation/form/field";
    private Resource resource;
    private String path = "/fake/path";
    private final EnumMap<ClientLibraryType, Set<String>> clientLibraries = new EnumMap(ClientLibraryType.class);
    private String category;

    public final void setup(String name, AccessibleObject fieldOrMethod, FormField field, SlingScriptHelper sling) {
        Optional<String> defaultValue;
        this.name = name;
        this.formField = field;
        this.sling = sling;
        this.accessibleObject = fieldOrMethod;
        this.setCategory(field.category());
        if (!this.properties.containsKey("name")) {
            this.properties.put("name", name);
        }
        this.properties.put("fieldLabel", this.formField.name());
        if (!StringUtils.isEmpty((String)this.formField.description())) {
            this.properties.put("fieldDescription", this.formField.description());
        }
        if (this.formField.required()) {
            this.properties.put("required", this.formField.required());
        }
        this.properties.put("emptyText", this.formField.hint());
        if (this.formField.showOnCreate()) {
            this.properties.put("cq:showOnCreate", true);
        }
        if (!(defaultValue = this.getOption("default")).isPresent()) {
            defaultValue = IntrospectionUtil.getDeclaredValue(fieldOrMethod).map(String::valueOf);
        }
        defaultValue.ifPresent(val -> this.properties.put("value", val));
        this.init();
    }

    public abstract void init();

    public final void setHelper(SlingScriptHelper helper) {
        this.sling = helper;
    }

    public final SlingScriptHelper getHelper() {
        return this.sling;
    }

    public final void setPath(String path) {
        this.path = path;
    }

    public final String getPath() {
        return this.path;
    }

    @Deprecated
    public final Field getField() {
        if (this.accessibleObject instanceof Field) {
            return (Field)this.accessibleObject;
        }
        return null;
    }

    public final AccessibleObject getAccessibleObject() {
        return this.accessibleObject;
    }

    public final FormField getFieldDefinition() {
        return this.formField;
    }

    public final String getHtml() {
        this.sling.include(this.getComponentResource());
        return "";
    }

    private Resource getComponentResource() {
        if (this.resource == null) {
            this.purgeEmptyProperties();
            this.resource = this.buildComponentResource();
            if (this.resource instanceof AbstractResourceImpl && this.sling != null) {
                ((AbstractResourceImpl)this.resource).setResourceResolver(this.sling.getRequest().getResourceResolver());
            }
        }
        return this.resource;
    }

    public Resource buildComponentResource() {
        this.purgeEmptyProperties();
        AbstractResourceImpl res = new AbstractResourceImpl(this.path, this.resourceType, this.resourceSuperType, this.properties);
        if (this.sling != null) {
            res.setResourceResolver(this.sling.getRequest().getResourceResolver());
        }
        return res;
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final Map<ClientLibraryType, Set<String>> getClientLibraryCategories() {
        return Collections.unmodifiableMap(this.clientLibraries);
    }

    public final void addClientLibrary(String category) {
        this.addClientLibraries(ClientLibraryType.ALL, Arrays.asList(category));
    }

    public final void addClientLibraries(ClientLibraryType type, String ... categories) {
        this.addClientLibraries(type, Arrays.asList(categories));
    }

    public final void addClientLibraries(ClientLibraryType type, Collection<String> categories) {
        Set categoriesSet = this.clientLibraries.getOrDefault((Object)type, new LinkedHashSet());
        categoriesSet.addAll(categories);
        this.clientLibraries.put(type, categoriesSet);
    }

    public final void addClientLibraries(FieldComponent component) {
        component.getClientLibraryCategories().forEach((type, categories) -> {
            if (categories != null) {
                this.addClientLibraries((ClientLibraryType)((Object)type), (Collection<String>)categories);
            }
        });
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public final void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public final String getResourceSuperType() {
        return this.resourceSuperType;
    }

    public final void setResourceSuperType(String resourceSuperType) {
        this.resourceSuperType = resourceSuperType;
    }

    public final void purgeEmptyProperties() {
        HashSet emptyKeys = new HashSet();
        this.properties.forEach((key, value) -> {
            if (value == null || "".equals(value)) {
                emptyKeys.add(key);
            }
        });
        this.properties.keySet().removeAll(emptyKeys);
    }

    public final String getName() {
        return this.name;
    }

    public final Collection<String> getOptionNames() {
        if (this.formField == null || this.formField.options() == null) {
            return Collections.emptySet();
        }
        return Stream.of(this.formField.options()).map(s -> StringUtils.substringBefore((String)s, (String)"=")).collect(Collectors.toList());
    }

    public final boolean hasOption(String optionName) {
        if (this.formField == null || this.formField.options() == null) {
            return false;
        }
        return Stream.of(this.formField.options()).filter(s -> s.equalsIgnoreCase(optionName) || s.startsWith(optionName + "=")).findFirst().isPresent();
    }

    public final Optional<String> getOption(String option) {
        if (this.formField == null || this.formField.options() == null) {
            return Optional.empty();
        }
        return Stream.of(this.formField.options()).filter(s -> s.startsWith(option + "=")).findFirst().map(o -> o.split("=")[1]);
    }

    public final Optional<Boolean> getBooleanOption(String option) {
        return this.getOption(option).map(s -> Variant.convert(s, Boolean.class));
    }

    public final String getCategory() {
        return this.category;
    }

    public final void setCategory(String category) {
        this.category = category;
    }

    public static enum ClientLibraryType {
        JS,
        CSS,
        ALL;

    }
}

