/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.functions;

import java.util.function.Function;
import org.osgi.annotation.versioning.ConsumerType;

@FunctionalInterface
@ConsumerType
public interface CheckedFunction<T, R> {
    public static <T, R> CheckedFunction<T, R> from(Function<T, R> function) {
        return function == null ? null : t -> function.apply(t);
    }

    public R apply(T var1) throws Exception;

    default public <V> CheckedFunction<V, R> compose(CheckedFunction<? super V, ? extends T> before) {
        if (before == null) {
            throw new NullPointerException();
        }
        return t -> this.apply(before.apply((Object)t));
    }

    default public <V> CheckedFunction<T, V> andThen(CheckedFunction<? super R, ? extends V> after) {
        if (after == null) {
            throw new NullPointerException();
        }
        return t -> after.apply((R)this.apply(t));
    }

    public static <T> CheckedFunction<T, T> identity() {
        return t -> t;
    }

    public static <T> CheckedFunction<T, Boolean> or(CheckedFunction<T, Boolean> ... functions) {
        return t -> {
            for (CheckedFunction f : functions) {
                if (!((Boolean)f.apply(t)).booleanValue()) continue;
                return true;
            }
            return false;
        };
    }
}

