/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.email.process.impl;

import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTemplatedEmailUtils {
    private static final Logger log = LoggerFactory.getLogger(SendTemplatedEmailUtils.class);
    private static final String PN_USER_EMAIL = "profile/email";

    private SendTemplatedEmailUtils() {
    }

    protected static final Map<String, String> getPayloadProperties(Resource payloadRes, SimpleDateFormat sdf) {
        HashMap<String, String> emailParams = new HashMap<String, String>();
        if (payloadRes == null) {
            return emailParams;
        }
        if (DamUtil.isAsset((Resource)payloadRes)) {
            Resource mdRes = payloadRes.getChild("jcr:content/metadata");
            Map<String, String> assetMetadata = SendTemplatedEmailUtils.getJcrKeyValuePairs(mdRes, sdf);
            emailParams.putAll(assetMetadata);
        } else {
            Page payloadPage = (Page)payloadRes.adaptTo(Page.class);
            if (payloadPage != null) {
                Map<String, String> pageContent = SendTemplatedEmailUtils.getJcrKeyValuePairs(payloadPage.getContentResource(), sdf);
                emailParams.putAll(pageContent);
            }
        }
        return emailParams;
    }

    protected static final String[] getEmailAddrsFromPathOrName(ResourceResolver resourceResolver, String principleOrPath) {
        if (StringUtils.startsWith((String)principleOrPath, (String)"/")) {
            return SendTemplatedEmailUtils.getEmailAddrsFromUserPath(resourceResolver, principleOrPath);
        }
        try {
            UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
            Authorizable auth = userManager.getAuthorizable(principleOrPath);
            return SendTemplatedEmailUtils.getEmailAddrsFromUserPath(resourceResolver, auth.getPath());
        }
        catch (RepositoryException e) {
            log.warn("Could not load repository paths for users. {}", (Throwable)e);
            return new String[0];
        }
    }

    protected static final String[] getEmailAddrsFromUserPath(ResourceResolver resourceResolver, String principlePath) {
        LinkedList<String> emailList = new LinkedList<String>();
        try {
            Authorizable authorizable;
            Resource authRes = resourceResolver.getResource(principlePath);
            if (authRes != null && (authorizable = (Authorizable)authRes.adaptTo(Authorizable.class)) != null) {
                if (authorizable.isGroup()) {
                    Group authGroup = (Group)authRes.adaptTo(Group.class);
                    Iterator memberIt = authGroup.getMembers();
                    while (memberIt.hasNext()) {
                        String currEmail = SendTemplatedEmailUtils.getAuthorizableEmail((Authorizable)memberIt.next());
                        if (currEmail == null) continue;
                        emailList.add(currEmail);
                    }
                } else {
                    String authEmail = SendTemplatedEmailUtils.getAuthorizableEmail(authorizable);
                    if (authEmail != null) {
                        emailList.add(authEmail);
                    }
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Could not get list of email(s) for users. {}", (Throwable)e);
        }
        String[] emailReturn = new String[emailList.size()];
        return emailList.toArray(emailReturn);
    }

    private static Map<String, String> getJcrKeyValuePairs(Resource resource, SimpleDateFormat sdf) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (resource == null) {
            return returnMap;
        }
        ValueMap resMap = resource.getValueMap();
        for (Map.Entry entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Calendar) {
                String fmtDate = SendTemplatedEmailUtils.formatDate((Calendar)value, sdf);
                returnMap.put((String)entry.getKey(), fmtDate);
                continue;
            }
            if (value instanceof String[]) {
                String strValue = StringUtils.join((Object[])((String[])value), (String)", ");
                returnMap.put((String)entry.getKey(), strValue);
                continue;
            }
            returnMap.put((String)entry.getKey(), value.toString());
        }
        return returnMap;
    }

    private static String getAuthorizableEmail(Authorizable authorizable) throws RepositoryException {
        if (authorizable.hasProperty(PN_USER_EMAIL)) {
            Value[] emailVal = authorizable.getProperty(PN_USER_EMAIL);
            return emailVal[0].getString();
        }
        return null;
    }

    private static String formatDate(Calendar calendar, SimpleDateFormat sdf) {
        return sdf.format(calendar.getTime());
    }
}

