/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.util.ParameterUtil;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.Filter;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Component(metatype=true, label="ACS AEM Commons - Site Map Servlet", description="Page and Asset Site Map Servlet", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", unbounded=PropertyUnbounded.ARRAY, label="Sling Resource Type", description="Sling Resource Type for the Home Page component or components."), @Property(name="sling.servlet.selectors", value={"sitemap"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"xml"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"Site Map for: {externalizer.domain}, on resource types: [{sling.servlet.resourceTypes}]"})})
public final class SiteMapServlet
extends SlingSafeMethodsServlet {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final boolean DEFAULT_INCLUDE_LAST_MODIFIED = false;
    private static final boolean DEFAULT_INCLUDE_INHERITANCE_VALUE = false;
    private static final String DEFAULT_EXTERNALIZER_DOMAIN = "publish";
    private static final boolean DEFAULT_EXTENSIONLESS_URLS = false;
    private static final boolean DEFAULT_REMOVE_TRAILING_SLASH = false;
    @Property(value={"publish"}, label="Externalizer Domain", description="Must correspond to a configuration of the Externalizer component.")
    private static final String PROP_EXTERNALIZER_DOMAIN = "externalizer.domain";
    @Property(boolValue={false}, label="Include Last Modified", description="If true, the last modified value will be included in the sitemap.")
    private static final String PROP_INCLUDE_LAST_MODIFIED = "include.lastmod";
    @Property(label="Change Frequency Properties", unbounded=PropertyUnbounded.ARRAY, description="The set of JCR property names which will contain the change frequency value.")
    private static final String PROP_CHANGE_FREQUENCY_PROPERTIES = "changefreq.properties";
    @Property(label="Priority Properties", unbounded=PropertyUnbounded.ARRAY, description="The set of JCR property names which will contain the priority value.")
    private static final String PROP_PRIORITY_PROPERTIES = "priority.properties";
    @Property(label="DAM Folder Property", description="The JCR property name which will contain DAM folders to include in the sitemap.")
    private static final String PROP_DAM_ASSETS_PROPERTY = "damassets.property";
    @Property(label="DAM Asset MIME Types", unbounded=PropertyUnbounded.ARRAY, description="MIME types allowed for DAM assets.")
    private static final String PROP_DAM_ASSETS_TYPES = "damassets.types";
    @Property(label="Exclude Pages (by properties of boolean values) from Sitemap Property", description="The boolean [cq:Page]/jcr:content property name which indicates if the Page should be hidden from the Sitemap.")
    private static final String PROP_EXCLUDE_FROM_SITEMAP_PROPERTY = "exclude.property";
    @Property(label="URL Rewrites", unbounded=PropertyUnbounded.ARRAY, description="Colon separated URL rewrites to adjust the <loc> to match your dispatcher's apache rewrites")
    private static final String PROP_URL_REWRITES = "url.rewrites";
    @Property(boolValue={false}, label="Include Inherit Value", description="If true searches for the frequency and priority attribute in the current page if null looks in the parent.")
    private static final String PROP_INCLUDE_INHERITANCE_VALUE = "include.inherit";
    @Property(boolValue={false}, label="Extensionless URLs", description="If true, page links included in sitemap are generated without .html extension and the path is included with a trailing slash, e.g. /content/geometrixx/en/.")
    private static final String PROP_EXTENSIONLESS_URLS = "extensionless.urls";
    @Property(boolValue={false}, label="Remove Trailing Slash from Extensionless URLs", description="Only relevant if Extensionless URLs is selected.  If true, the trailing slash is removed from extensionless page links, e.g. /content/geometrixx/en.")
    private static final String PROP_REMOVE_TRAILING_SLASH = "remove.slash";
    @Property(label="Character Encoding", description="If not set, the container's default is used (ISO-8859-1 for Jetty)")
    private static final String PROP_CHARACTER_ENCODING_PROPERTY = "character.encoding";
    @Property(label="Exclude Pages (by Template) from Sitemap", description="Excludes pages that have a matching value at [cq:Page]/jcr:content@cq:Template")
    private static final String TEMPLATE_EXCLUDE_FROM_SITEMAP_PROPERTY = "exclude.templates";
    private static final String NS = "http://www.sitemaps.org/schemas/sitemap/0.9";
    @Reference
    private transient Externalizer externalizer;
    private String externalizerDomain;
    private boolean includeInheritValue;
    private boolean includeLastModified;
    private String[] changefreqProperties;
    private String[] priorityProperties;
    private String damAssetProperty;
    private List<String> damAssetTypes;
    private List<String> excludeFromSiteMapProperty;
    private String characterEncoding;
    private boolean extensionlessUrls;
    private Map<String, String> urlRewrites;
    private boolean removeTrailingSlash;
    private List<String> excludedPageTemplates;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.externalizerDomain = PropertiesUtil.toString((Object)properties.get(PROP_EXTERNALIZER_DOMAIN), (String)DEFAULT_EXTERNALIZER_DOMAIN);
        this.includeLastModified = PropertiesUtil.toBoolean((Object)properties.get(PROP_INCLUDE_LAST_MODIFIED), (boolean)false);
        this.includeInheritValue = PropertiesUtil.toBoolean((Object)properties.get(PROP_INCLUDE_INHERITANCE_VALUE), (boolean)false);
        this.changefreqProperties = PropertiesUtil.toStringArray((Object)properties.get(PROP_CHANGE_FREQUENCY_PROPERTIES), (String[])new String[0]);
        this.priorityProperties = PropertiesUtil.toStringArray((Object)properties.get(PROP_PRIORITY_PROPERTIES), (String[])new String[0]);
        this.damAssetProperty = PropertiesUtil.toString((Object)properties.get(PROP_DAM_ASSETS_PROPERTY), (String)"");
        this.damAssetTypes = Arrays.asList(PropertiesUtil.toStringArray((Object)properties.get(PROP_DAM_ASSETS_TYPES), (String[])new String[0]));
        this.excludeFromSiteMapProperty = Arrays.asList(PropertiesUtil.toStringArray((Object)properties.get(PROP_EXCLUDE_FROM_SITEMAP_PROPERTY), (String[])new String[0]));
        this.characterEncoding = PropertiesUtil.toString((Object)properties.get(PROP_CHARACTER_ENCODING_PROPERTY), null);
        this.extensionlessUrls = PropertiesUtil.toBoolean((Object)properties.get(PROP_EXTENSIONLESS_URLS), (boolean)false);
        this.urlRewrites = ParameterUtil.toMap(PropertiesUtil.toStringArray((Object)properties.get(PROP_URL_REWRITES), (String[])new String[0]), ":", true, "");
        this.removeTrailingSlash = PropertiesUtil.toBoolean((Object)properties.get(PROP_REMOVE_TRAILING_SLASH), (boolean)false);
        this.excludedPageTemplates = Arrays.asList(PropertiesUtil.toStringArray((Object)properties.get(TEMPLATE_EXCLUDE_FROM_SITEMAP_PROPERTY), (String[])new String[0]));
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType(request.getResponseContentType());
        if (StringUtils.isNotEmpty((CharSequence)this.characterEncoding)) {
            response.setCharacterEncoding(this.characterEncoding);
        }
        ResourceResolver resourceResolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(request.getResource());
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            XMLStreamWriter stream = outputFactory.createXMLStreamWriter(response.getWriter());
            stream.writeStartDocument("1.0");
            stream.writeStartElement("", "urlset", NS);
            stream.writeNamespace("", NS);
            this.write(page, stream, resourceResolver);
            Iterator children = page.listChildren((Filter)new PageFilter(false, true), true);
            while (children.hasNext()) {
                this.write((Page)children.next(), stream, resourceResolver);
            }
            if (this.damAssetTypes.size() > 0 && this.damAssetProperty.length() > 0) {
                for (Resource assetFolder : this.getAssetFolders(page, resourceResolver)) {
                    this.writeAssets(stream, assetFolder, resourceResolver);
                }
            }
            stream.writeEndElement();
            stream.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private Collection<Resource> getAssetFolders(Page page, ResourceResolver resolver) {
        ArrayList<Resource> allAssetFolders = new ArrayList<Resource>();
        ValueMap properties = page.getProperties();
        Object[] configuredAssetFolderPaths = (String[])properties.get(this.damAssetProperty, String[].class);
        if (configuredAssetFolderPaths != null) {
            Arrays.sort(configuredAssetFolderPaths);
            Object prevPath = "#";
            for (Object configuredAssetFolderPath : configuredAssetFolderPaths) {
                Resource assetFolder;
                if (!StringUtils.isNotBlank((CharSequence)configuredAssetFolderPath) || ((String)configuredAssetFolderPath).equals(prevPath) || StringUtils.startsWith((CharSequence)configuredAssetFolderPath, (CharSequence)((String)prevPath + "/")) || (assetFolder = resolver.getResource((String)configuredAssetFolderPath)) == null) continue;
                prevPath = configuredAssetFolderPath;
                allAssetFolders.add(assetFolder);
            }
        }
        return allAssetFolders;
    }

    private String applyUrlRewrites(String url) {
        try {
            String path = URI.create(url).getPath();
            for (Map.Entry<String, String> rewrite : this.urlRewrites.entrySet()) {
                if (!path.startsWith(rewrite.getKey())) continue;
                return url.replaceFirst(rewrite.getKey(), rewrite.getValue());
            }
            return url;
        }
        catch (IllegalArgumentException e) {
            return url;
        }
    }

    private void write(Page page, XMLStreamWriter stream, ResourceResolver resolver) throws XMLStreamException {
        Calendar cal;
        if (this.isHiddenByPageProperty(page) || this.isHiddenByPageTemplate(page)) {
            return;
        }
        stream.writeStartElement(NS, "url");
        String loc = "";
        if (!StringUtils.isEmpty((CharSequence)page.getVanityUrl())) {
            loc = this.externalizer.externalLink(resolver, this.externalizerDomain, page.getVanityUrl());
        } else if (!this.extensionlessUrls) {
            loc = this.externalizer.externalLink(resolver, this.externalizerDomain, String.format("%s.html", page.getPath()));
        } else {
            String urlFormat = this.removeTrailingSlash ? "%s" : "%s/";
            loc = this.externalizer.externalLink(resolver, this.externalizerDomain, String.format(urlFormat, page.getPath()));
        }
        loc = this.applyUrlRewrites(loc);
        this.writeElement(stream, "loc", loc);
        if (this.includeLastModified && (cal = page.getLastModified()) != null) {
            this.writeElement(stream, "lastmod", DATE_FORMAT.format(cal));
        }
        if (this.includeInheritValue) {
            HierarchyNodeInheritanceValueMap hierarchyNodeInheritanceValueMap = new HierarchyNodeInheritanceValueMap(page.getContentResource());
            this.writeFirstPropertyValue(stream, "changefreq", this.changefreqProperties, (InheritanceValueMap)hierarchyNodeInheritanceValueMap);
            this.writeFirstPropertyValue(stream, "priority", this.priorityProperties, (InheritanceValueMap)hierarchyNodeInheritanceValueMap);
        } else {
            ValueMap properties = page.getProperties();
            this.writeFirstPropertyValue(stream, "changefreq", this.changefreqProperties, properties);
            this.writeFirstPropertyValue(stream, "priority", this.priorityProperties, properties);
        }
        stream.writeEndElement();
    }

    private boolean isHiddenByPageProperty(Page page) {
        boolean flag = false;
        if (this.excludeFromSiteMapProperty != null) {
            for (String pageProperty : this.excludeFromSiteMapProperty) {
                flag = flag || (Boolean)page.getProperties().get(pageProperty, (Object)Boolean.FALSE) != false;
            }
        }
        return flag;
    }

    private boolean isHiddenByPageTemplate(Page page) {
        boolean flag = false;
        if (this.excludedPageTemplates != null) {
            for (String pageTemplate : this.excludedPageTemplates) {
                flag = flag || ((String)page.getProperties().get("cq:template", (Object)"")).equalsIgnoreCase(pageTemplate);
            }
        }
        return flag;
    }

    private void writeAsset(Asset asset, XMLStreamWriter stream, ResourceResolver resolver) throws XMLStreamException {
        Resource contentResource;
        long lastModified;
        stream.writeStartElement(NS, "url");
        String loc = this.externalizer.externalLink(resolver, this.externalizerDomain, asset.getPath());
        this.writeElement(stream, "loc", loc);
        if (this.includeLastModified && (lastModified = asset.getLastModified()) > 0L) {
            this.writeElement(stream, "lastmod", DATE_FORMAT.format(lastModified));
        }
        if ((contentResource = ((Resource)asset.adaptTo(Resource.class)).getChild("jcr:content")) != null) {
            if (this.includeInheritValue) {
                HierarchyNodeInheritanceValueMap hierarchyNodeInheritanceValueMap = new HierarchyNodeInheritanceValueMap(contentResource);
                this.writeFirstPropertyValue(stream, "changefreq", this.changefreqProperties, (InheritanceValueMap)hierarchyNodeInheritanceValueMap);
                this.writeFirstPropertyValue(stream, "priority", this.priorityProperties, (InheritanceValueMap)hierarchyNodeInheritanceValueMap);
            } else {
                ValueMap properties = contentResource.getValueMap();
                this.writeFirstPropertyValue(stream, "changefreq", this.changefreqProperties, properties);
                this.writeFirstPropertyValue(stream, "priority", this.priorityProperties, properties);
            }
        }
        stream.writeEndElement();
    }

    private void writeAssets(XMLStreamWriter stream, Resource assetFolder, ResourceResolver resolver) throws XMLStreamException {
        Iterator children = assetFolder.listChildren();
        while (children.hasNext()) {
            Resource assetFolderChild = (Resource)children.next();
            if (assetFolderChild.isResourceType("dam:Asset")) {
                Asset asset = (Asset)assetFolderChild.adaptTo(Asset.class);
                if (!this.damAssetTypes.contains(asset.getMimeType())) continue;
                this.writeAsset(asset, stream, resolver);
                continue;
            }
            this.writeAssets(stream, assetFolderChild, resolver);
        }
    }

    private void writeFirstPropertyValue(XMLStreamWriter stream, String elementName, String[] propertyNames, ValueMap properties) throws XMLStreamException {
        for (String prop : propertyNames) {
            String value = (String)properties.get(prop, String.class);
            if (value == null) continue;
            this.writeElement(stream, elementName, value);
            break;
        }
    }

    private void writeFirstPropertyValue(XMLStreamWriter stream, String elementName, String[] propertyNames, InheritanceValueMap properties) throws XMLStreamException {
        for (String prop : propertyNames) {
            String value = (String)properties.get(prop, String.class);
            if (value == null) {
                value = (String)properties.getInherited(prop, String.class);
            }
            if (value == null) continue;
            this.writeElement(stream, elementName, value);
            break;
        }
    }

    private void writeElement(XMLStreamWriter stream, String elementName, String text) throws XMLStreamException {
        stream.writeStartElement(NS, elementName);
        stream.writeCharacters(text);
        stream.writeEndElement();
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

