/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.commons.Externalizer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - QR Code Configuration Servlet", policy=ConfigurationPolicy.REQUIRE, immediate=true)
@Properties(value={@Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="sling.servlet.resourceTypes", value={"acs-commons/components/utilities/qr-code/config"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"json"}, propertyPrivate=true)})
@Service
public class QrCodeServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(QrCodeServlet.class);
    private static final String PN_ENABLED = "enabled";
    private static final String JSON_KEY_ENABLED = "enabled";
    private static final String JSON_KEY_PUBLISH_URL = "publishURL";
    @Reference
    private transient Externalizer externalizer;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        if (this.externalizer == null) {
            log.warn("Externalizer is not configured. This is required for QR Code servlet to work.");
            response.setStatus(500);
        } else if (((Boolean)request.getResource().getValueMap().get("enabled", (Object)false)).booleanValue()) {
            JsonObject json = new JsonObject();
            String publishUrl = this.externalizer.publishLink(request.getResourceResolver(), request.getRequestPathInfo().getSuffix());
            log.debug("Externalized path [ {} ] for QR Code generation to [ {} ]", (Object)request.getRequestPathInfo().getSuffix(), (Object)publishUrl);
            if (StringUtils.isNotBlank((CharSequence)publishUrl)) {
                json.addProperty("enabled", Boolean.valueOf(true));
                json.addProperty(JSON_KEY_PUBLISH_URL, publishUrl);
                Gson gson = new Gson();
                gson.toJson((JsonElement)json, (Appendable)response.getWriter());
                response.getWriter().flush();
            } else {
                log.warn("Externalizer configuration for AEM Publish did not yield a valid URL");
                response.setStatus(500);
            }
        } else {
            log.warn("Externalizer configuration for AEM Publish did not yield a valid URL");
            response.setStatus(500);
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

