/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.json.AbstractJSONObjectVisitor;
import com.adobe.acs.commons.json.JsonObjectUtil;
import com.adobe.acs.commons.util.BufferedSlingHttpServletResponse;
import com.adobe.acs.commons.util.InfoWriter;
import com.adobe.acs.commons.util.PathInfoUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(label="ACS AEM Commons - CQInclude Property Namespace", metatype=true, selectors={"overlay.cqinclude.namespace"}, extensions={"json"}, resourceTypes={"sling/servlet/default"})
public final class CQIncludePropertyNamespaceServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CQIncludePropertyNamespaceServlet.class);
    private static final String REQ_ATTR = CQIncludePropertyNamespaceServlet.class.getName() + ".processed";
    private static final String AEM_CQ_INCLUDE_SELECTORS = "overlay.infinity";
    private static final String CQINCLUDE_NAMESPACE_URL_REGEX = "(.+\\.cqinclude\\.namespace\\.)(.+)(\\.json)";
    private static final int NAME_PROPERTY_SELECTOR_INDEX = 3;
    private static final String PN_NAME = "name";
    private static final String PN_XTYPE = "xtype";
    private static final String PN_PATH = "path";
    private static final String NT_CQ_WIDGET = "cq:Widget";
    private static final String ESCAPED_SLASH = "%252F";
    private static final String[] DEFAULT_NAMESPACEABLE_PROPERTY_NAMES = new String[]{"name", "cropParameter", "fileNameParameter", "fileReferenceParameter", "mapParameter", "rotateParameter", "widthParameter", "heightParameter"};
    private String[] namespaceablePropertyNames = null;
    @Property(label="Property Names", description="Namespace properties defined in this list. Leave empty for on 'name'.  Defaults to [ name, cropParameter, fileNameParameter, fileReferenceParameter, mapParameter, rotateParameter, widthParameter, heightParameter] ", value={"name", "cropParameter", "fileNameParameter", "fileReferenceParameter", "mapParameter", "rotateParameter", "widthParameter", "heightParameter"})
    public static final String PROP_NAMESPACEABLE_PROPERTY_NAMES = "namespace.property-names";
    private static final String[] DEFAULT_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS = new String[]{"^\\./.*"};
    private List<Pattern> namespaceablePropertyValuePatterns = new ArrayList<Pattern>();
    @Property(label="Property Value Patterns", description="Namespace properties whose values match a regex in this list. Defaults to [ \"^\\\\./.*\" ]", value={"^\\./.*"})
    public static final String PROP_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS = "namespace.property-value-patterns";
    private static final boolean DEFAULT_SUPPORT_MULTI_LEVEL = false;
    private boolean supportMultiLevel = false;
    @Property(label="Support Multi-level", description="When set to true, cqinclude servlet will support multi-level path-ing if nested cqinclude namespaces. Defaults to false", boolValue={false})
    public static final String PROP_SUPPORT_MULTI_LEVEL = "namespace.multi-level";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        if (!this.accepts(request)) {
            response.setStatus(404);
            response.getWriter().write("{}");
        }
        RequestUtil.setRequestAttribute((HttpServletRequest)request, (String)REQ_ATTR, (Object)true);
        String namespace = URLDecoder.decode(PathInfoUtil.getSelector(request, 3), "UTF-8");
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors(AEM_CQ_INCLUDE_SELECTORS);
        BufferedSlingHttpServletResponse bufferedResponse = new BufferedSlingHttpServletResponse(response, new StringWriter(), null);
        request.getRequestDispatcher(request.getResource(), options).forward((ServletRequest)request, (ServletResponse)bufferedResponse);
        Gson gson = new Gson();
        JsonObject json = gson.toJsonTree((Object)bufferedResponse.getBufferedServletOutput().getBufferedString()).getAsJsonObject();
        PropertyNamespaceUpdater propertyNamespaceUpdater = new PropertyNamespaceUpdater(namespace);
        propertyNamespaceUpdater.accept(json);
        response.getWriter().write(json.toString());
    }

    protected boolean accepts(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR) != null) {
            log.warn("Identified a cyclic loop in the ACS Commons CQ Include Namespace prefix Servlet for [ {} ]", (Object)request.getRequestURI());
            return false;
        }
        for (int i = 0; i <= 3; ++i) {
            if (!StringUtils.isBlank((String)PathInfoUtil.getSelector(request, i))) continue;
            return false;
        }
        return true;
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        String[] regexes;
        this.supportMultiLevel = PropertiesUtil.toBoolean((Object)config.get(PROP_SUPPORT_MULTI_LEVEL), (boolean)false);
        this.namespaceablePropertyNames = PropertiesUtil.toStringArray((Object)config.get(PROP_NAMESPACEABLE_PROPERTY_NAMES), (String[])DEFAULT_NAMESPACEABLE_PROPERTY_NAMES);
        this.namespaceablePropertyValuePatterns = new ArrayList<Pattern>();
        for (String regex : regexes = PropertiesUtil.toStringArray((Object)config.get(PROP_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS), (String[])DEFAULT_NAMESPACEABLE_PROPERTY_VALUE_PATTERNS)) {
            this.namespaceablePropertyValuePatterns.add(Pattern.compile(regex));
        }
        InfoWriter iw = new InfoWriter();
        iw.title("ACS AEM Commons - CQInclude Property Namespace Servlet");
        iw.message("Namespace-able Property Names: {}", Arrays.asList(this.namespaceablePropertyNames));
        iw.message("Namespace-able Property Value Patterns: {}", this.namespaceablePropertyValuePatterns);
        iw.end();
        log.info(iw.toString());
    }

    public final class PropertyNamespaceUpdater
    extends AbstractJSONObjectVisitor {
        private final String namespace;
        private static final String DOT_SLASH = "./";

        public PropertyNamespaceUpdater(String namespace) {
            this.namespace = namespace;
        }

        private boolean accept(String propertyName, String propertyValue) {
            if (CQIncludePropertyNamespaceServlet.this.namespaceablePropertyNames != null) {
                for (String name : CQIncludePropertyNamespaceServlet.this.namespaceablePropertyNames) {
                    if (!StringUtils.equals((String)name, (String)propertyName)) continue;
                    return true;
                }
            }
            if (CQIncludePropertyNamespaceServlet.this.namespaceablePropertyValuePatterns != null) {
                for (Pattern pattern : CQIncludePropertyNamespaceServlet.this.namespaceablePropertyValuePatterns) {
                    Matcher matcher = pattern.matcher(propertyValue);
                    if (!matcher.matches()) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isCqincludeNamespaceWidget(JsonObject jsonObject) {
            String path;
            return StringUtils.equals((String)JsonObjectUtil.getString(jsonObject, "jcr:primaryType"), (String)CQIncludePropertyNamespaceServlet.NT_CQ_WIDGET) && StringUtils.equals((String)JsonObjectUtil.getString(jsonObject, CQIncludePropertyNamespaceServlet.PN_XTYPE), (String)"cqinclude") && StringUtils.isNotBlank((String)(path = JsonObjectUtil.getString(jsonObject, CQIncludePropertyNamespaceServlet.PN_PATH))) && path.matches(CQIncludePropertyNamespaceServlet.CQINCLUDE_NAMESPACE_URL_REGEX);
        }

        protected JsonObject makeMultiLevel(JsonObject jsonObject) {
            Pattern pattern;
            Matcher m;
            String path = JsonObjectUtil.getString(jsonObject, CQIncludePropertyNamespaceServlet.PN_PATH);
            if (StringUtils.isNotBlank((String)path) && (m = (pattern = Pattern.compile(CQIncludePropertyNamespaceServlet.CQINCLUDE_NAMESPACE_URL_REGEX)).matcher(path)).matches()) {
                path = m.group(1) + this.namespace + CQIncludePropertyNamespaceServlet.ESCAPED_SLASH + m.group(2) + m.group(3);
                jsonObject.addProperty(CQIncludePropertyNamespaceServlet.PN_PATH, path);
            }
            return jsonObject;
        }

        @Override
        protected void visit(JsonObject jsonObject) {
            if (StringUtils.equals((String)JsonObjectUtil.getString(jsonObject, "jcr:primaryType"), (String)CQIncludePropertyNamespaceServlet.NT_CQ_WIDGET)) {
                if (CQIncludePropertyNamespaceServlet.this.supportMultiLevel && this.isCqincludeNamespaceWidget(jsonObject)) {
                    jsonObject = this.makeMultiLevel(jsonObject);
                }
                for (Map.Entry elem : jsonObject.entrySet()) {
                    String value;
                    String propertyName = (String)elem.getKey();
                    if (!this.accept(propertyName, value = ((JsonElement)elem.getValue()).getAsString())) {
                        log.debug("Property [ {} ~> {} ] is not a namespace-able property name/value", (Object)propertyName, (Object)value);
                        continue;
                    }
                    if (value == null) continue;
                    String prefix = "";
                    if (StringUtils.startsWith((String)value, (String)DOT_SLASH)) {
                        value = StringUtils.removeStart((String)value, (String)DOT_SLASH);
                        prefix = DOT_SLASH;
                    }
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    jsonObject.addProperty(propertyName, prefix + this.namespace + "/" + value);
                }
            }
        }
    }
}

