/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

abstract class AbstractDynamicClientLibraryServlet
extends SlingSafeMethodsServlet {
    private transient HtmlLibraryManager htmlLibraryManager;
    private String[] categories;
    private boolean excludeAll;

    AbstractDynamicClientLibraryServlet() {
    }

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        Collection libraries;
        ResourceResolver resourceResolver = request.getResourceResolver();
        response.setContentType("application/json");
        JsonWriter writer = new JsonWriter((Writer)response.getWriter());
        writer.beginObject();
        writer.name("js");
        writer.beginArray();
        if (!this.excludeAll) {
            libraries = this.htmlLibraryManager.getLibraries(this.categories, LibraryType.JS, true, true);
            for (ClientLibrary library : libraries) {
                writer.value(resourceResolver.map((HttpServletRequest)request, library.getIncludePath(LibraryType.JS, this.htmlLibraryManager.isMinifyEnabled())));
            }
        }
        writer.endArray();
        writer.name("css");
        writer.beginArray();
        if (!this.excludeAll) {
            libraries = this.htmlLibraryManager.getLibraries(this.categories, LibraryType.CSS, true, true);
            for (ClientLibrary library : libraries) {
                writer.value(resourceResolver.map((HttpServletRequest)request, library.getIncludePath(LibraryType.CSS, this.htmlLibraryManager.isMinifyEnabled())));
            }
        }
        writer.endArray();
        writer.endObject();
    }

    protected void activate(String[] categories, boolean excludeAll, HtmlLibraryManager htmlLibraryManager) {
        this.categories = categories;
        this.excludeAll = excludeAll;
        this.htmlLibraryManager = htmlLibraryManager;
    }
}

