/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import com.adobe.acs.commons.util.impl.Activator;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverridePathSlingRequestWrapper
extends SlingHttpServletRequestWrapper {
    private static final String ATTR_SLING_BINDINGS = SlingBindings.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(OverridePathSlingRequestWrapper.class);
    private final SlingBindings myBindings = new SlingBindings();
    private final Resource resource;
    private final Map<Class<?>, Object> adaptersCache = new HashMap();

    public OverridePathSlingRequestWrapper(SlingHttpServletRequest request, String path) {
        super(request);
        SlingBindings slingBindings = (SlingBindings)this.getSlingRequest().getAttribute(ATTR_SLING_BINDINGS);
        this.resource = this.getSlingRequest().getResourceResolver().resolve((HttpServletRequest)this.getSlingRequest(), path);
        if (slingBindings != null) {
            this.myBindings.putAll((Map)slingBindings);
        }
        this.myBindings.put((Object)"properties", (Object)this.resource.getValueMap());
        this.myBindings.put((Object)"resource", (Object)this.resource);
        this.myBindings.put((Object)"request", (Object)this);
        Page currentPage = null;
        PageManager pageManager = (PageManager)this.getSlingRequest().getResourceResolver().adaptTo(PageManager.class);
        if (pageManager != null) {
            currentPage = pageManager.getContainingPage(this.resource);
        }
        this.myBindings.put((Object)"currentPage", (Object)currentPage);
    }

    public Object getAttribute(String name) {
        if (ATTR_SLING_BINDINGS.equals(name)) {
            return this.myBindings;
        }
        return super.getAttribute(name);
    }

    public Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        Object result = null;
        OverridePathSlingRequestWrapper overridePathSlingRequestWrapper = this;
        synchronized (overridePathSlingRequestWrapper) {
            result = this.adaptersCache.get(type);
            if (result == null) {
                AdapterManager mgr = Activator.getAdapterManager();
                if (mgr == null) {
                    LOG.warn("Unable to adapt request for path {} to {} because AdapterManager is null", (Object)this.resource.getPath(), type);
                } else {
                    result = mgr.getAdapter((Object)this, type);
                }
                if (result != null) {
                    this.adaptersCache.put(type, result);
                }
            }
            return (AdapterType)result;
        }
    }
}

