/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.impl;

import com.adobe.acs.commons.redirectmaps.impl.RedirectEntriesUtils;
import com.adobe.acs.commons.util.RequireAem;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/redirectmappage"}, selectors={"removeentry"}, extensions={"json"}, metatype=false)
public class RemoveEntryServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -5963945855717054678L;
    private static final Logger log = LoggerFactory.getLogger(RemoveEntryServlet.class);
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        log.trace("doPost");
        int idx = Integer.parseInt(request.getParameter("idx"), 10);
        log.debug("Removing index {}", (Object)idx);
        List<String> lines = RedirectEntriesUtils.readEntries(request);
        lines.remove(idx);
        log.debug("Removed line...");
        RedirectEntriesUtils.updateRedirectMap(request, lines);
        RedirectEntriesUtils.writeEntriesToResponse(request, response, "Removed entry " + idx);
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }
}

