/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.mcp.impl.processes.renovator.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceFinder {
    private static final Logger log = LoggerFactory.getLogger(ReferenceFinder.class);
    private final List<Pair<String, String>> allReferences = new ArrayList<Pair<String, String>>();
    private final boolean exact;
    private final List<String> publishedReferences = new ArrayList<String>();
    private final String reference;

    private static Resource getClosestPublishableType(Resource resource) {
        if ("cq:Page".equals(resource.getResourceType()) || "dam:Asset".equals(resource.getResourceType())) {
            return resource;
        }
        if (resource.getParent() != null) {
            return ReferenceFinder.getClosestPublishableType(resource.getParent());
        }
        return null;
    }

    public ReferenceFinder(ResourceResolver resolver, String reference, String searchRoot, boolean exact) {
        this.exact = exact;
        this.reference = reference;
        HashSet paths = new HashSet();
        this.findReferences(resolver, reference, searchRoot).forEach(r -> {
            if (!paths.contains(r.getPath())) {
                this.checkReferences((Resource)r);
                paths.add(r.getPath());
            }
        });
    }

    private void addReference(Resource resource, String key) {
        Resource parent = ReferenceFinder.getClosestPublishableType(resource);
        if (parent != null && Util.isActivated(resource.getResourceResolver(), parent.getPath())) {
            this.publishedReferences.add(parent.getPath());
            this.allReferences.add((Pair<String, String>)new ImmutablePair((Object)resource.getPath(), (Object)key));
        } else {
            this.allReferences.add((Pair<String, String>)new ImmutablePair((Object)resource.getPath(), (Object)key));
        }
    }

    private void checkReferences(Resource resource) {
        log.trace("Checking for references in resource {}", (Object)resource);
        ValueMap properties = resource.getValueMap();
        properties.keySet().forEach(k -> {
            if (properties.get(k) instanceof String) {
                this.checkStringReference(resource, properties, (String)k);
            } else if (properties.get(k) instanceof String[]) {
                this.checkStringArrayReference(resource, properties, (String)k);
            }
        });
    }

    private void checkStringArrayReference(Resource resource, ValueMap properties, String k) {
        for (String v : (String[])properties.get(k, String[].class)) {
            if (!this.reference.equals(v) && (this.exact || v == null || !v.contains(this.reference))) continue;
            log.trace("Found reference in property {}@{}", (Object)resource.getPath(), (Object)k);
            this.addReference(resource, k);
            break;
        }
    }

    private void checkStringReference(Resource resource, ValueMap properties, String k) {
        String value = (String)properties.get(k, (Object)"");
        if (this.reference.equals(value) || !this.exact && value.contains(this.reference)) {
            log.trace("Found reference in property {}@{}", (Object)resource.getPath(), (Object)k);
            this.addReference(resource, k);
        }
    }

    protected Stream<Resource> findReferences(ResourceResolver resolver, String reference, String searchRoot) {
        log.trace("Finding references to {}", (Object)reference);
        String query = "SELECT * FROM [nt:base] AS s WHERE ISDESCENDANTNODE([" + searchRoot + "]) AND CONTAINS(s.*, '" + Text.escapeIllegalXpathSearchChars((String)reference) + "')";
        log.trace("Checking for references with: {}", (Object)query);
        Iterable resources = () -> resolver.findResources(query, "JCR-SQL2");
        return StreamSupport.stream(resources.spliterator(), false);
    }

    public List<Pair<String, String>> getAllReferences() {
        return this.allReferences;
    }

    public List<String> getPublishedReferences() {
        return this.publishedReferences;
    }
}

