/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.mem.impl;

import acscommons.com.google.common.collect.HashMultimap;
import acscommons.com.google.common.collect.Multimap;
import acscommons.com.google.common.collect.Multimaps;
import com.adobe.acs.commons.httpcache.engine.HttpCacheServletResponseWrapper;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;

public class MemCachePersistenceObject
implements Serializable {
    private int status;
    private String charEncoding;
    private String contentType;
    transient Multimap<String, String> headers;
    private byte[] bytes;
    private HttpCacheServletResponseWrapper.ResponseWriteMethod writeMethod;
    AtomicInteger count = new AtomicInteger(0);

    public MemCachePersistenceObject buildForCaching(int status, String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream, HttpCacheServletResponseWrapper.ResponseWriteMethod writeMethod) throws HttpCacheDataStreamException {
        this.status = status;
        this.charEncoding = charEncoding;
        this.contentType = contentType;
        this.writeMethod = writeMethod;
        this.headers = HashMultimap.create();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                if ("Sling-Tracer-Protocol-Version".equals(entry.getKey()) || "Sling-Tracer-Request-Id".equals(entry.getKey())) continue;
                this.headers.put(entry.getKey(), value);
            }
        }
        try {
            this.bytes = IOUtils.toByteArray((InputStream)dataInputStream);
        }
        catch (IOException e) {
            throw new HttpCacheDataStreamException("Unable to get byte array out of stream", e);
        }
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, Collection<String>> entry : Multimaps.asMap(this.headers).entrySet()) {
            map.put(entry.getKey(), new ArrayList<String>(entry.getValue()));
        }
        return map;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void incrementHitCount() {
        this.count.incrementAndGet();
    }

    public int getHitCount() {
        return this.count.get();
    }

    public HttpCacheServletResponseWrapper.ResponseWriteMethod getWriteMethod() {
        return this.writeMethod;
    }
}

