/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.hc.impl;

import com.adobe.acs.commons.util.RequireAem;
import com.day.cq.commons.mail.MailTemplate;
import com.day.cq.mailer.MessageGateway;
import com.day.cq.mailer.MessageGatewayService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.mail.SimpleEmail;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Health Check - SMTP E-Mail Service", description="Checks if the AEM E-Mail Service can connect and send mail via the configured SMTP server.", policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="hc.name", value={"SMTP Mail Service"}, propertyPrivate=true), @Property(label="Tags", name="hc.tags", unbounded=PropertyUnbounded.ARRAY, value={"integrations", "smtp", "email"}, description="Tags for this check to be used by composite health checks."), @Property(name="hc.mbean.name", value={"smtpMailService"}, propertyPrivate=true)})
@Service
public class SMTPMailServiceHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(SMTPMailServiceHealthCheck.class);
    private static final int TIMEOUT = 10000;
    private static String MAIL_TEMPLATE = System.getProperty("line.separator") + "Sling Health Check for AEM E-mail Service connectivity";
    private static final String DEFAULT_EMAIL = "healthcheck@example.com";
    @Property(label="Test E-mail Address", description="E-mail address to send test message to.", value={"healthcheck@example.com"})
    private static final String PROP_EMAIL = "email";
    private String toEmail;
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    private MessageGatewayService messageGatewayService;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.toEmail = PropertiesUtil.toString((Object)properties.get(PROP_EMAIL), (String)DEFAULT_EMAIL);
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        if (this.messageGatewayService == null) {
            resultLog.critical("MessageGatewayService OSGi service could not be found.", new Object[0]);
            resultLog.info("Verify the Default Mail Service is active: http://<host>:<port>/system/console/components/com.day.cq.mailer.impl.CqMailingService", new Object[0]);
        } else {
            MessageGateway messageGateway = this.messageGatewayService.getGateway(SimpleEmail.class);
            if (messageGateway == null) {
                resultLog.critical("The AEM Default Mail Service is INACTIVE, thus e-mails cannot be sent.", new Object[0]);
                resultLog.info("Verify the Default Mail Service is active and configured: http://<host>:<port>/system/console/components/com.day.cq.mailer.DefaultMailService", new Object[0]);
                log.warn("Could not retrieve a SimpleEmail Message Gateway");
            } else {
                try {
                    ArrayList<InternetAddress> emailAddresses = new ArrayList<InternetAddress>();
                    emailAddresses.add(new InternetAddress(this.toEmail));
                    MailTemplate mailTemplate = new MailTemplate(IOUtils.toInputStream((String)MAIL_TEMPLATE, (String)"UTF-8"), "UTF-8");
                    SimpleEmail email = (SimpleEmail)mailTemplate.getEmail(StrLookup.mapLookup(Collections.emptyMap()), SimpleEmail.class);
                    email.setSubject("AEM E-mail Service Health Check");
                    email.setTo(emailAddresses);
                    email.setSocketConnectionTimeout(10000);
                    email.setSocketTimeout(10000);
                    try {
                        messageGateway.send((Object)email);
                        resultLog.info("The E-mail Service appears to be working properly. Verify the health check e-mail was sent to [ {} ]", new Object[]{this.toEmail});
                    }
                    catch (Exception e) {
                        resultLog.critical("Failed sending e-mail. Unable to send a test toEmail via the configured E-mail server: " + e.getMessage(), new Object[]{e});
                        log.warn("Failed to send E-mail for E-mail Service health check", (Throwable)e);
                    }
                    this.logMailServiceConfig(resultLog, email);
                }
                catch (Exception e) {
                    resultLog.healthCheckError("Sling Health check could not formulate a test toEmail: " + e.getMessage(), new Object[]{e});
                    log.error("Unable to execute E-mail health check", (Throwable)e);
                }
            }
        }
        return new Result((ResultLog)resultLog);
    }

    private void logMailServiceConfig(FormattingResultLog resultLog, SimpleEmail email) {
        resultLog.info("SMTP Host: {}", new Object[]{email.getHostName()});
        resultLog.info("SMTP use SSL: {}", new Object[]{email.isSSL()});
        if (email.isSSL()) {
            resultLog.info("SMTP SSL Port: {}", new Object[]{email.getSslSmtpPort()});
        } else {
            resultLog.info("SMTP Port: {}", new Object[]{email.getSmtpPort()});
        }
        resultLog.info("SMTP From Address: {}", new Object[]{email.getFromAddress()});
        resultLog.info("Socket Connection Timeout: {} seconds", new Object[]{email.getSocketConnectionTimeout() / 1000});
        resultLog.info("Socket IO Timeout: {} seconds", new Object[]{email.getSocketTimeout() / 1000});
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }

    protected void bindMessageGatewayService(MessageGatewayService messageGatewayService) {
        this.messageGatewayService = messageGatewayService;
    }

    protected void unbindMessageGatewayService(MessageGatewayService messageGatewayService) {
        if (this.messageGatewayService == messageGatewayService) {
            this.messageGatewayService = null;
        }
    }
}

